/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.gradle;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Version;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.gradle.ext.Buildship;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class GradleBuildshipIntegration {
    private static final Log log = Log.getInstance(GradleBuildshipIntegration.class);
    private static final Log consolelog = ConsoleLog.getInstance(GradleBuildshipIntegration.class);
    private static final long GRADLE_BUILD_WARN_THRESHOLD = 5000L;

    public static Buildship.BuildWrapper getGradleBuild(IProject project) {
        Buildship buildship = BuildshipHolder.INSTANCE;
        if (buildship == null || !buildship.hasGradleNature(project)) {
            return null;
        }
        return buildship.getGradleBuild(project);
    }

    public static Buildship.ProjectWrapper getGradleProject(IProject project, Buildship.BuildWrapper gradleBuild) throws Exception {
        if (!project.isOpen() || project.getLocation() == null) {
            return null;
        }
        return GradleBuildshipIntegration.measureExecution("findGradleProject", () -> gradleBuild.findGradleProject(project));
    }

    public static String runGradleTask(String task, Buildship.ProjectWrapper gradleProject, Buildship.BuildWrapper gradleBuild, List<String> args) throws Exception {
        String projectAndTask = String.valueOf(gradleProject.getProjectPath()) + ":" + task;
        String taskOutput = GradleBuildshipIntegration.getTaskOutput(gradleBuild, projectAndTask, args);
        log.trace("{} task output for '{}': {}", new Object[]{projectAndTask, gradleBuild, taskOutput});
        return taskOutput;
    }

    private static String getTaskOutput(final Buildship.BuildWrapper gradleBuild, final String taskName, final List<String> args) throws Exception {
        final AtomicReference buildOutput = new AtomicReference();
        final AtomicReference buildError = new AtomicReference();
        Job job = new Job("JRebel gradle task: " + taskName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String result = (String)GradleBuildshipIntegration.measureExecution(taskName, () -> gradleBuild.runTask(taskName, monitor, args));
                    buildOutput.set(result);
                }
                catch (Exception e) {
                    buildError.set(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        job.join();
        if (buildError.get() != null) {
            throw (Exception)buildError.get();
        }
        return (String)buildOutput.get();
    }

    private static <T> T measureExecution(String task, Callable<T> op) throws Exception {
        long start = System.nanoTime();
        try {
            T t = op.call();
            return t;
        }
        finally {
            long durationMs = (System.nanoTime() - start) / 1000000L;
            if (durationMs > 5000L) {
                log.warn("OVERTIME: {} ms, task: {}", (Object)durationMs, (Object)task);
            }
        }
    }

    private static Buildship load() {
        String versionString = PlatformInfo.getFeatureVersion((String)"org.eclipse.buildship", null);
        if (versionString == null) {
            return null;
        }
        if ("3.0.0.v20181106-1441-m".equals(versionString)) {
            GradleBuildshipIntegration.warnUnsupportedVersion(versionString);
            return null;
        }
        try {
            Version version = new Version(versionString);
            for (Buildship buildship : Hooks.getHookList(Buildship.class, (String)"org.zeroturnaround.eclipse.gradle.buildship")) {
                if (!buildship.isSupported(version)) continue;
                return buildship;
            }
        }
        catch (Throwable t) {
            log.error("Failed to find buildship integration for version {}", (Object)versionString, (Object)t);
        }
        return null;
    }

    private static void warnUnsupportedVersion(String versionString) {
        String msg = String.format("Version '%s' of Buildship plugin is unsupported. Please upgrade.", versionString);
        log.warn(msg);
        consolelog.warn(msg);
        ConsoleLog.open();
    }

    static /* synthetic */ Buildship access$0() {
        return GradleBuildshipIntegration.load();
    }

    static class BuildshipHolder {
        private static final Buildship INSTANCE = GradleBuildshipIntegration.access$0();

        BuildshipHolder() {
        }
    }
}

