/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.gradle;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.zeroturnaround.eclipse.gradle.GradleBuildshipIntegration;
import org.zeroturnaround.eclipse.gradle.ext.Buildship;
import org.zeroturnaround.jrebel.client.logger.Log;

public class GradleModuleVersion {
    private static final Log log = Log.getInstance(GradleModuleVersion.class);
    private static final String GAV_TASK = "jrPrintArtifact";
    private static final String GAV_INIT_SCRIPT = "allprojects {\n  task jrPrintArtifact {\n    doFirst {\n      println \"name: ${project.name}\"\n      println \"group: ${project.group}\"\n    }\n  }\n}";
    private static final String NAME = "name: ";
    private static final String GROUP = "group: ";
    private static final Map<String, ModuleInfo> moduleInfoCache = new HashMap<String, ModuleInfo>();

    public static String getGroup(IProject project) {
        ModuleInfo moduleInfo = GradleModuleVersion.getOrComputeModuleVersion(project);
        if (moduleInfo == null) {
            return null;
        }
        return moduleInfo.getGroup();
    }

    public static String getName(IProject project) {
        ModuleInfo moduleInfo = GradleModuleVersion.getOrComputeModuleVersion(project);
        if (moduleInfo == null) {
            return null;
        }
        return moduleInfo.getName();
    }

    private static ModuleInfo getOrComputeModuleVersion(IProject project) {
        Buildship.BuildWrapper build = GradleBuildshipIntegration.getGradleBuild(project);
        if (build == null) {
            return null;
        }
        Buildship.ProjectWrapper gradleProject = build.findGradleProject(project);
        if (gradleProject == null) {
            return null;
        }
        String projectPath = gradleProject.getProjectPath();
        ModuleInfo moduleInfo = moduleInfoCache.get(projectPath);
        if (moduleInfo == null) {
            moduleInfo = GradleModuleVersion.computeModuleVersion(build, gradleProject);
            moduleInfoCache.put(projectPath, moduleInfo);
        }
        return moduleInfo;
    }

    /*
     * Loose catch block
     */
    private static ModuleInfo computeModuleVersion(Buildship.BuildWrapper build, Buildship.ProjectWrapper project) {
        ModuleInfo moduleInfo;
        Path initScript;
        block15: {
            initScript = null;
            initScript = Files.createTempFile("gradle-init", "groovy", new FileAttribute[0]);
            Files.write(initScript, GAV_INIT_SCRIPT.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            String output = GradleBuildshipIntegration.runGradleTask(GAV_TASK, project, build, Arrays.asList("--init-script", initScript.toString()));
            String name = null;
            String group = null;
            String[] stringArray = output.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith(NAME)) {
                    name = line.substring(NAME.length());
                } else if (line.startsWith(GROUP)) {
                    group = line.substring(GROUP.length());
                }
                ++n2;
            }
            moduleInfo = new ModuleInfo(group, name);
            if (initScript == null) break block15;
            try {
                Files.deleteIfExists(initScript);
            }
            catch (IOException iOException) {}
        }
        return moduleInfo;
        catch (Exception e) {
            block16: {
                try {
                    log.error("Failed to get project group, id & version", (Throwable)e);
                    if (initScript == null) break block16;
                }
                catch (Throwable throwable) {
                    if (initScript != null) {
                        try {
                            Files.deleteIfExists(initScript);
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(initScript);
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    static class ModuleInfo {
        private final String group;
        private final String name;

        ModuleInfo(String group, String name) {
            this.group = group;
            this.name = name;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }
    }
}

