/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.websphere;

import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.containers.websphere.WASRebelServer;
import org.zeroturnaround.eclipse.wtp.containers.websphere.WebsphereUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class MyEclipseWASRebelServer
extends WASRebelServer {
    private static final Log log = Log.getInstance(MyEclipseWASRebelServer.class);
    private final String cellName;
    private final String nodeName;

    private MyEclipseWASRebelServer() {
        this(null, null);
    }

    public MyEclipseWASRebelServer(String cellName, String nodeName) {
        log.info("MyEclipseWASRebelServer.MyEclipseWASRebelServer. cellName: " + cellName + " nodeName: " + nodeName);
        this.cellName = cellName;
        this.nodeName = nodeName;
    }

    @Override
    protected String getServerXmlPath(IServer server) {
        log.info("MyEclipseWASRebelServer.getServerXmlPath. server: " + server);
        String serverLocation = MyEclipseWASRebelServer.getServerInstallationPath(server);
        String profileName = ServerHelper.getAttribute((IServerAttributes)server, (String)"profile-name", (String)"unknown");
        String profilePath = WebsphereUtil.getProfilePath(serverLocation, profileName);
        log.info("Found profile from: " + profilePath);
        String serverName = ServerHelper.getAttribute((IServerAttributes)server, (String)"server-name", (String)"unknown");
        log.info("Using server with name: " + serverName);
        String serverXmlPath = WebsphereUtil.getServerXmlPath(profilePath, this.cellName, this.nodeName, serverName);
        log.info("Using server.xml: " + serverXmlPath);
        return serverXmlPath;
    }

    private static String getServerInstallationPath(IServer server) {
        IPath loc = server.getRuntime().getLocation();
        if (loc == null) {
            String serverLocAttr = ServerHelper.getAttribute((IServerAttributes)server, (String)"server-location", null);
            if (serverLocAttr == null) {
                throw new RuntimeException("Cannot determine server location.");
            }
            return serverLocAttr;
        }
        return loc.toOSString();
    }
}

