/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.websphere;

import com.ibm.ws.ast.st.common.core.internal.AbstractWASServer;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.common.Function0;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.args.store.WebSphereXmlArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.server.websphere.WASVariables;
import org.zeroturnaround.eclipse.wtp.containers.websphere.WebsphereUtil;
import org.zeroturnaround.eclipse.wtp.launching.RebelServer;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.logger.Log;

public class WASRebelServer
extends RebelServer {
    private static final Log log = Log.getInstance(WASRebelServer.class);

    public IPersistentArgStore getArgStore(IServer server, IServerWorkingCopy workingCopy) throws CoreException {
        log.trace("WASRebelServer.getArgStore. server: " + server + " workingCopy: " + workingCopy);
        return new WebSphereXmlArgStore(new File(this.getServerXmlPath(server)));
    }

    protected void modifyArgumentsOnJRebelEnabledChange(IServer server, ArgChanges changes, boolean enable, JavaVM vm) {
        if (enable && vm.isIBM()) {
            changes.add((IArgument)RebelArgs.SHARECLASSES_NONE);
        } else {
            changes.remove((IArgument)RebelArgs.SHARECLASSES_NONE);
        }
    }

    public JavaVM getJVM(final IServer server) throws CoreException {
        Maybe.None javaHomeOpt = Maybe.none();
        try {
            WASVariables was = WASVariables.fromServerXmlPath((File)new File(this.getServerXmlPath(server)));
            javaHomeOpt = was.getJavaHome();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        String javaHome = (String)javaHomeOpt.getOrElse((Function0)new Function0<String>(){

            public String apply() {
                String javaHome = server.getRuntime().getLocation().append("java").toOSString();
                if (javaHome != null && javaHome.contains("%20")) {
                    javaHome = javaHome.replace("%20", " ");
                }
                return javaHome;
            }
        });
        log.info("[bootstrap generator] Resolved WAS Java runtime to: " + javaHome);
        return JavaVM.getJavaJVM((String)javaHome);
    }

    protected String getServerXmlPath(IServer server) throws CoreException {
        try {
            AbstractWASServer wasServer = WASRebelServer.getWASServer(server);
            log.trace("WebsphereUtil.getServerXmlPath. server: " + wasServer);
            String installPath = wasServer.getWebSphereInstallPath();
            log.trace("[jrebel WAS integration] server install path: " + installPath);
            if (installPath != null && installPath.contains("%20")) {
                installPath = installPath.replace("%20", " ");
                log.trace("[jrebel WAS integration] server install path cleaned: " + installPath);
            }
            String profileName = wasServer.getProfileName();
            String baseServerName = wasServer.getBaseServerName();
            log.info(" -- server params are: { installPath=" + installPath + " profileName=" + profileName + " baseServerName=" + baseServerName + "}");
            String profilePath = WebsphereUtil.getProfilePath(installPath, profileName);
            return WebsphereUtil.getServerXmlPath(profilePath, baseServerName);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private static AbstractWASServer getWASServer(IServer server) throws CoreException {
        AbstractWASServer wasServer = (AbstractWASServer)server.loadAdapter(AbstractWASServer.class, (IProgressMonitor)new NullProgressMonitor());
        log.info(" -- wasServer is : " + wasServer.toString());
        return wasServer;
    }
}

