/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.websphere;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.containers.websphere.MyEclipseWASRebelServer;
import org.zeroturnaround.eclipse.wtp.containers.websphere.WASRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServerProvider;
import org.zeroturnaround.eclipse.wtp.launching.RebelServerProviders;
import org.zeroturnaround.jrebel.client.logger.Log;

public class WASRebelServerProvider
implements IRebelServerProvider {
    private static final Log log = Log.getInstance(WASRebelServerProvider.class);
    private static final String[] WEBSPHERE_ADAPTOR_SERVER_IDS = new String[]{"com.ibm.ws.ast.st.*"};
    private static final String[] MYECLIPSE_WEBSPHERE_ADAPTOR_SERVER_IDS = new String[]{"com.genuitec.blue.websphere.server.*", "com.genuitec.blue.websphere.portal.server.*"};

    public IRebelServer createRebelServer(IServer server) {
        return this.createRebelServer(server, null);
    }

    public IRebelServer createRebelServer(IServer server, Map cookies) {
        log.trace("WASRebelServerProvider.createRebelServer. server: " + server);
        if (RebelServerProviders.typeIdMatches((IServer)server, (String[])WEBSPHERE_ADAPTOR_SERVER_IDS)) {
            return new WASRebelServer();
        }
        if (RebelServerProviders.typeIdMatches((IServer)server, (String[])MYECLIPSE_WEBSPHERE_ADAPTOR_SERVER_IDS)) {
            if (cookies == null) {
                log.info("cookies is null. lookup from launch conf");
                try {
                    ILaunchConfiguration lc = server.getLaunchConfiguration(false, null);
                    if (lc != null) {
                        cookies = lc.getAttributes();
                    }
                }
                catch (CoreException e) {
                    log.warn((Throwable)e);
                }
            }
            if (cookies != null) {
                Pair<String, String> values = this.getCellNameAndNodeName(server, (String)cookies.get("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_PROG_ARGS"));
                return new MyEclipseWASRebelServer((String)values.getLeft(), (String)values.getRight());
            }
            log.info("didn't get cookies for MyEclipse WAS");
            return null;
        }
        return null;
    }

    private Pair<String, String> getCellNameAndNodeName(IServer server, String programArgument) {
        String[] split = programArgument.split(" ");
        String serverName = ServerHelper.getAttribute((IServerAttributes)server, (String)"server-name", null);
        int i = 0;
        while (i < split.length) {
            if (split[i].equalsIgnoreCase(serverName) && i >= 2) {
                return Pair.of((Object)split[i - 2], (Object)split[i - 1]);
            }
            ++i;
        }
        log.info("lookup failed. program args " + programArgument + " serverName " + serverName);
        log.error("Could not determine cell and node name.", (Throwable)new RuntimeException("unknown WAS cell"));
        return Pair.of((Object)"unknownCell", (Object)"unknownNode");
    }
}

