/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.websphere;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.zeroturnaround.jrebel.client.logger.Log;

public class WebsphereUtil {
    private static final Log log = Log.getInstance(WebsphereUtil.class);
    private static final String PROFILE_REGISTRY_KEY = "WS_PROFILE_REGISTRY";
    private static final String WAS_PROFILE_PROPERTIES = "wasprofile.properties";
    private static final String WAS_PROFILE_REGISTRY = "profileRegistry.xml";

    protected static void debug(String msg) {
        log.debug(msg);
    }

    protected static void trace(String msg) {
        log.debug(msg);
    }

    protected static String getProfilePath(String serverInstallPath, String profileName) {
        File profileFile;
        String xpath = "/*/profile[@name='" + profileName + "']/@path";
        File profileRegistryFile = WebsphereUtil.getProfileRegistryPath(serverInstallPath);
        String profilePath = WebsphereUtil.getXPathValue(profileRegistryFile, xpath);
        if (profilePath != null && (profileFile = new File(profilePath)).exists()) {
            return profilePath;
        }
        log.info("profile can not be found from " + profileRegistryFile.getPath() + " with XPath " + xpath);
        String defaultProfileLocation = Path.fromOSString((String)serverInstallPath).append("profiles").append(profileName).toOSString();
        if (new File(defaultProfileLocation).exists()) {
            log.info("found profile from " + defaultProfileLocation);
            return defaultProfileLocation;
        }
        return null;
    }

    private static File getProfileRegistryPath(String serverInstallPath) {
        String profileRegistry = "properties" + File.separator + WAS_PROFILE_REGISTRY;
        File registry = new File(new File(serverInstallPath), profileRegistry);
        if (!registry.exists()) {
            log.info("profileRegistry not at " + registry.getPath());
            Properties wasProperties = WebsphereUtil.loadWasProfileProperties(serverInstallPath);
            String profileRegistryPath = (String)wasProperties.get(PROFILE_REGISTRY_KEY);
            if (profileRegistryPath == null) {
                log.warn("wasprofile does not contain WS_PROFILE_REGISTRY");
                return null;
            }
            log.info("found profileRegistry path: " + profileRegistryPath);
            if (profileRegistryPath.indexOf("${was.install.root}") != -1) {
                profileRegistryPath = profileRegistryPath.replace("${was.install.root}", serverInstallPath);
            }
            registry = new File(profileRegistryPath);
        }
        return registry;
    }

    private static Properties loadWasProfileProperties(String serverInstallPath) {
        String wasPropertiesPath = "properties" + File.separator + WAS_PROFILE_PROPERTIES;
        File wasPropertiesFile = new File(new File(serverInstallPath), wasPropertiesPath);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(wasPropertiesFile));
        }
        catch (FileNotFoundException e) {
            log.info(String.valueOf(wasPropertiesFile.getPath()) + " not found", (Throwable)e);
        }
        catch (IOException e) {
            log.info("Error looking up wasprofile.properties", (Throwable)e);
        }
        return properties;
    }

    private static String getXPathValue(File file, String xPath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(xPath);
            return (String)expr.evaluate(doc, XPathConstants.STRING);
        }
        catch (Exception e) {
            log.error("getting value via XPath threw exception", (Throwable)e);
            return null;
        }
    }

    protected static String getServerXmlPath(String profilePath, String serverName) {
        try {
            IPath serverLevelPath = WebsphereUtil.getServerLevelPath(profilePath, serverName);
            IPath serverXMLPath = serverLevelPath.append("server.xml");
            log.info("Using server.xml: " + serverXMLPath.toOSString());
            return serverXMLPath.toOSString();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private static IPath getServerLevelPath(String profilePath, String serverName) throws Exception {
        IPath serversPath = WebsphereUtil.getNodeLevelPath(profilePath).append("servers");
        log.debug("Using servers directory: " + serversPath.toOSString());
        return serversPath.append(serverName);
    }

    private static IPath getNodeLevelPath(String profilePath) throws Exception {
        IPath nodesPath = WebsphereUtil.getCellLevelPath(profilePath).append("nodes");
        log.debug("Using nodes directory: " + nodesPath.toOSString());
        return WebsphereUtil.findAndVerify(nodesPath, new String[]{"servers", "node.xml"});
    }

    private static IPath getCellLevelPath(String profilePath) throws Exception {
        IPath cellsDir = new Path(profilePath).append("config").append("cells");
        log.debug("Using cells directory: " + cellsDir.toOSString());
        return WebsphereUtil.findAndVerify(cellsDir, new String[]{"nodes", "cell.xml"});
    }

    private static IPath findAndVerify(IPath path, String[] verifyList) throws Exception {
        File[] files;
        File fp = new File(path.toString());
        if (fp.exists() && fp.isDirectory() && (files = fp.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                IPath childPath = path.append(file.getName());
                if (WebsphereUtil.verifyDirectory(childPath, verifyList)) {
                    return childPath;
                }
                ++n2;
            }
        }
        log.error("Couldn't find {} from any of the folders at {}", Arrays.asList(verifyList), (Object)path.toOSString());
        throw new Exception("server.xml not found");
    }

    private static boolean verifyDirectory(IPath path, String[] verifyList) {
        if (path == null || !path.toFile().exists()) {
            return false;
        }
        if (verifyList != null) {
            String[] stringArray = verifyList;
            int n = verifyList.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!path.append(file).toFile().exists()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected static String getServerXmlPath(String profilePath, String cellName, String nodeName, String serverName) {
        return Path.fromOSString((String)profilePath).append("config").append("cells").append(cellName).append("nodes").append(nodeName).append("servers").append(serverName).append("server.xml").toOSString();
    }
}

