/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.maven;

import org.zeroturnaround.jrebel.client.logger.Log;

public class MavenIntegrationChecker {
    private static final Log log = Log.getInstance(MavenIntegrationChecker.class);
    private static final boolean IS_SUPPORTED = MavenIntegrationChecker.hasMavenPlugin();

    public static boolean isSupported() {
        return IS_SUPPORTED;
    }

    private static boolean hasMavenPlugin() {
        if (!MavenIntegrationChecker.hasClass("org.eclipse.m2e.core.MavenPlugin")) {
            log.debug("Not found org.eclipse.m2e.core.MavenPlugin");
            return false;
        }
        return true;
    }

    private static boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

