/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlGenerator;
import org.zeroturnaround.eclipse.maven.MavenIntegrationChecker;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.xmlgen.BuildTool;

public class MavenRebelXmlGenerator
implements IRebelXmlGenerator {
    private static final Log log = Log.getInstance(MavenRebelXmlGenerator.class);

    public boolean canGenerate(IProject project) {
        log.info("canGenerate rebel.xml for Project {} with Maven", (Object)project);
        if (!MavenIntegrationChecker.isSupported()) {
            return false;
        }
        return this.generate(project, null, true) == IRebelXmlGenerator.ExternalGenerationResult.OK;
    }

    public IRebelXmlGenerator.BuildToolSupportStatus supportStatus() {
        return new IRebelXmlGenerator.BuildToolSupportStatus(BuildTool.MAVEN, MavenIntegrationChecker.isSupported());
    }

    public IRebelXmlGenerator.GenerationResult generate(IProject project, File destinationFolder) {
        log.info("generate rebel.xml for Project {} in folder {} with Maven", (Object)project, (Object)destinationFolder);
        if (!MavenIntegrationChecker.isSupported()) {
            if (this.hasConfigurationFile(project)) {
                return new IRebelXmlGenerator.GenerationResult(BuildTool.MAVEN, IRebelXmlGenerator.ExternalGenerationResult.UNSUPPORTED);
            }
            return new IRebelXmlGenerator.GenerationResult(BuildTool.MAVEN, IRebelXmlGenerator.ExternalGenerationResult.MISSING_CONF_FILE);
        }
        return new IRebelXmlGenerator.GenerationResult(BuildTool.MAVEN, this.generate(project, destinationFolder, false));
    }

    private boolean hasConfigurationFile(IProject project) {
        return project.getFile("pom.xml").exists();
    }

    private IRebelXmlGenerator.ExternalGenerationResult generate(IProject project, File destinationFolder, boolean dryRun) {
        try {
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                log.info("Project {} has no Maven nature", (Object)project);
                return IRebelXmlGenerator.ExternalGenerationResult.MISCONFIGURED;
            }
            IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().getProject(project);
            if (projectFacade == null) {
                log.info("Project {} has Maven nature, but no facade", (Object)project);
                return IRebelXmlGenerator.ExternalGenerationResult.MISCONFIGURED;
            }
            MavenProject mvnProject = projectFacade.getMavenProject(null);
            Plugin plugin = mvnProject.getPlugin("org.zeroturnaround:jrebel-maven-plugin");
            if (plugin == null) {
                log.info("Project {} has Maven nature, but no jrebel plugin", (Object)project);
                return IRebelXmlGenerator.ExternalGenerationResult.MISSING_PLUGIN;
            }
            if (dryRun) {
                return IRebelXmlGenerator.ExternalGenerationResult.OK;
            }
            return this.runTarget(mvnProject, this.getExecutionId(plugin), destinationFolder) ? IRebelXmlGenerator.ExternalGenerationResult.OK : IRebelXmlGenerator.ExternalGenerationResult.FAILED;
        }
        catch (Exception e) {
            log.error("Error generating rebel.xml with Maven", (Throwable)e);
            return IRebelXmlGenerator.ExternalGenerationResult.FAILED;
        }
    }

    private String getExecutionId(Plugin plugin) {
        List execution = plugin.getExecutions();
        String execId = execution.isEmpty() ? "default-cli" : ((PluginExecution)execution.get(0)).getId();
        return "jrebel:generate@" + execId;
    }

    private boolean runTarget(MavenProject mvnProject, String execId, File destinationFolder) {
        try {
            MavenExecutionResult result;
            IMaven mvn = MavenPlugin.getMaven();
            IMavenExecutionContext executionContext = mvn.createExecutionContext();
            MavenExecutionRequest request = executionContext.getExecutionRequest();
            request.setInteractiveMode(false);
            request.setBaseDirectory(mvnProject.getBasedir());
            request.setPom(mvnProject.getFile());
            request.setGoals(Collections.singletonList(execId));
            request.getUserProperties().setProperty("rebel.xml.dir", destinationFolder.getAbsolutePath());
            request.setRecursive(false);
            request.setNoSnapshotUpdates(true);
            request.addActiveProfiles(this.getProjectProfiles(mvnProject));
            log.info("Running mvn execution: {}, request: {}", (Object)execId, (Object)request);
            try {
                Method execute = IMavenExecutionContext.class.getDeclaredMethod("execute", MavenExecutionRequest.class);
                result = (MavenExecutionResult)execute.invoke((Object)executionContext, request);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                result = mvn.execute(request, null);
            }
            for (Throwable t : result.getExceptions()) {
                log.error("Exception running maven target", t);
            }
            return !result.hasExceptions();
        }
        catch (Exception ex) {
            log.error("Error running target with Maven", (Throwable)ex);
            return false;
        }
    }

    private List<String> getProjectProfiles(MavenProject mvnProject) {
        LinkedHashSet profiles = new LinkedHashSet();
        for (List values : mvnProject.getInjectedProfileIds().values()) {
            profiles.addAll(values);
        }
        return new ArrayList<String>(profiles);
    }
}

