/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.maven;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlLocator;
import org.zeroturnaround.eclipse.maven.MavenIntegrationChecker;
import org.zeroturnaround.jrebel.client.logger.Log;

public class MavenRebelXmlLocator
implements IRebelXmlLocator {
    private static final Log log = Log.getInstance(MavenRebelXmlLocator.class);
    private static final IPath DEFAULT_RESOURCE = new Path("src/main/resources");

    public IPath getRebelXmlLocation(EclipseIdeProject project) {
        IMavenProjectFacade projectFacade;
        block8: {
            block7: {
                if (!MavenIntegrationChecker.isSupported()) {
                    return null;
                }
                try {
                    if (project.getEclipseProject().hasNature("org.eclipse.m2e.core.maven2Nature")) break block7;
                    return null;
                }
                catch (Exception e) {
                    log.error("Error reading maven info to find rebel.xml location:", (Throwable)e);
                    return null;
                }
            }
            projectFacade = MavenPlugin.getMavenProjectRegistry().getProject(project.getEclipseProject());
            if (projectFacade != null) break block8;
            log.info("Project {} has Maven nature, but no facade", (Object)project);
            return null;
        }
        log.debug("Project {} has Maven nature, searching for resources configuration", (Object)project);
        Method m_getResourceLocations = projectFacade.getClass().getDeclaredMethod("getResourceLocations", null);
        Class<List> m_returnType = m_getResourceLocations.getReturnType();
        if (!m_returnType.isArray()) {
            if (m_returnType.isAssignableFrom(List.class)) {
                Object m_result = m_getResourceLocations.invoke((Object)projectFacade, null);
                IPath[] newarray = ((List)m_result).toArray(new IPath[0]);
                log.debug("using an array converted from a List");
                return MavenRebelXmlLocator.findBestLocation(newarray);
            }
            log.warn("getResourceLocations() return type is not array or List. It is " + m_returnType);
        }
        IPath[] resourceLocations = projectFacade.getResourceLocations();
        return MavenRebelXmlLocator.findBestLocation(resourceLocations);
    }

    public void updateRebelXmlCache(EclipseIdeProject project, boolean force) {
    }

    static IPath findBestLocation(IPath[] resourceDirs) {
        if (resourceDirs != null && resourceDirs.length >= 1) {
            if (Arrays.asList(resourceDirs).contains(DEFAULT_RESOURCE)) {
                return DEFAULT_RESOURCE;
            }
            ArrayList<IPath> resourceDirsSorted = new ArrayList<IPath>();
            IPath[] iPathArray = resourceDirs;
            int n = resourceDirs.length;
            int n2 = 0;
            while (n2 < n) {
                IPath iPath = iPathArray[n2];
                if (iPath != null && !"".equals(iPath.toString())) {
                    resourceDirsSorted.add(iPath);
                }
                ++n2;
            }
            Collections.sort(resourceDirsSorted, (o1, o2) -> o1.toString().compareTo(o2.toString()));
            if (!resourceDirsSorted.isEmpty()) {
                return (IPath)resourceDirsSorted.get(0);
            }
        }
        return DEFAULT_RESOURCE;
    }
}

