/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.maven;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.zeroturnaround.eclipse.actions.extension.IMavenProjectInfo;
import org.zeroturnaround.eclipse.maven.MavenIntegrationChecker;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelMavenProjectInfo
implements IMavenProjectInfo {
    private static final Log log = Log.getInstance(RebelMavenProjectInfo.class);

    public String getMavenArtifactId(IProject project) {
        MavenProject mavenProject = RebelMavenProjectInfo.getMavenProject(project);
        return mavenProject != null ? mavenProject.getArtifactId() : null;
    }

    public String getMavenGroupId(IProject project) {
        MavenProject mavenProject = RebelMavenProjectInfo.getMavenProject(project);
        return mavenProject != null ? mavenProject.getGroupId() : null;
    }

    private static MavenProject getMavenProject(IProject project) {
        if (MavenIntegrationChecker.isSupported()) {
            IMavenProjectFacade mavenProjectFacade = MavenPlugin.getMavenProjectRegistry().getProject(project);
            if (mavenProjectFacade != null && mavenProjectFacade.getMavenProject() != null) {
                return mavenProjectFacade.getMavenProject();
            }
            log.debug("Maven integration not found for project {}", (Object)project.getName());
        } else {
            log.debug("Maven integration not available");
        }
        return null;
    }
}

