/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.gradle.buildship2;

import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;
import org.zeroturnaround.eclipse.gradle.ext.Buildship;

public class BuildshipImpl
implements Buildship {
    public boolean isSupported(Version version) {
        return version.compareTo(new Version("2.0")) >= 0 && version.compareTo(new Version("3.0")) < 0;
    }

    public boolean hasGradleNature(IProject project) {
        return GradleProjectNature.isPresentOn((IProject)project);
    }

    public Buildship.BuildWrapper getGradleBuild(IProject project) {
        GradleBuild b = (GradleBuild)CorePlugin.gradleWorkspaceManager().getGradleBuild(project).orNull();
        if (b != null) {
            return new GradleBuildWrapper(b);
        }
        return null;
    }

    private static class GradleBuildWrapper
    implements Buildship.BuildWrapper {
        private final GradleBuild build;

        private GradleBuildWrapper(GradleBuild build) {
            this.build = build;
        }

        public Buildship.ProjectWrapper findGradleProject(IProject project) {
            File projectFolder = project.getLocation().toFile().getAbsoluteFile();
            Set projects = this.build.getModelProvider().fetchEclipseGradleProjects(FetchStrategy.LOAD_IF_NOT_CACHED, null, null);
            for (OmniEclipseProject eclipseProject : projects) {
                if (!eclipseProject.getProjectDirectory().equals(projectFolder)) continue;
                return new OmniEclipseProjectWrapper(eclipseProject);
            }
            return null;
        }

        public String runTask(String taskName, IProgressMonitor monitor, List<String> args) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BuildLaunchRequest launchRequest = CorePlugin.toolingClient().newBuildLaunchRequest(LaunchableConfig.forTasks((String[])new String[]{taskName})).arguments(args.toArray(new String[0])).standardOutput((OutputStream)out).standardError((OutputStream)out);
            this.addGradleSettings(this.build, launchRequest);
            launchRequest.executeAndWait();
            return new String(out.toByteArray());
        }

        private void addGradleSettings(GradleBuild gradleBuild, BuildLaunchRequest launchRequest) throws Exception {
            try {
                Object requestAttributes = MethodUtils.invokeMethod((Object)gradleBuild, (boolean)true, (String)"getRequestAttributes");
                MethodUtils.invokeMethod((Object)requestAttributes, (boolean)true, (String)"apply", (Object[])new Object[]{launchRequest});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Object buildConfig = MethodUtils.invokeMethod((Object)gradleBuild, (boolean)true, (String)"getBuildConfig");
                launchRequest.projectDir((File)MethodUtils.invokeMethod((Object)buildConfig, (boolean)true, (String)"getRootProjectDirectory"));
                launchRequest.gradleUserHomeDir((File)MethodUtils.invokeMethod((Object)buildConfig, (boolean)true, (String)"getGradleUserHome"));
                launchRequest.gradleDistribution((GradleDistribution)MethodUtils.invokeMethod((Object)buildConfig, (boolean)true, (String)"getGradleDistribution"));
            }
        }
    }

    private static class OmniEclipseProjectWrapper
    implements Buildship.ProjectWrapper {
        private final OmniEclipseProject project;

        private OmniEclipseProjectWrapper(OmniEclipseProject project) {
            this.project = project;
        }

        public String getProjectPath() {
            return this.project.getProjectIdentifier().getProjectPath();
        }
    }
}

