/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.gradle.buildship3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.osgi.framework.Version;
import org.zeroturnaround.eclipse.gradle.ext.Buildship;

public class BuildshipImpl
implements Buildship {
    public boolean isSupported(Version version) {
        return version.compareTo(new Version("3.0")) >= 0;
    }

    public boolean hasGradleNature(IProject project) {
        return GradleProjectNature.isPresentOn((IProject)project);
    }

    public Buildship.BuildWrapper getGradleBuild(IProject project) {
        return GradleCore.getWorkspace().getBuild(project).filter(build -> build instanceof InternalGradleBuild).map(build -> new InternalGradleBuildWrapper((InternalGradleBuild)build)).orElse(null);
    }

    private static class EclipseProjectWrapper
    implements Buildship.ProjectWrapper {
        private final EclipseProject project;

        private EclipseProjectWrapper(EclipseProject project) {
            this.project = project;
        }

        public String getProjectPath() {
            return this.project.getProjectIdentifier().getProjectPath();
        }
    }

    private static class InternalGradleBuildWrapper
    implements Buildship.BuildWrapper {
        private final InternalGradleBuild build;

        private InternalGradleBuildWrapper(InternalGradleBuild build) {
            this.build = build;
        }

        public Buildship.ProjectWrapper findGradleProject(IProject project) {
            File projectFolder = project.getLocation().toFile().getAbsoluteFile();
            Collection<EclipseProject> projects = this.fetchEclipseProjectModels(this.build.getModelProvider());
            ArrayDeque<EclipseProject> allChildren = new ArrayDeque<EclipseProject>(projects);
            while (!allChildren.isEmpty()) {
                EclipseProject eclipseProject = (EclipseProject)allChildren.poll();
                if (eclipseProject.getProjectDirectory().equals(projectFolder)) {
                    return new EclipseProjectWrapper(eclipseProject);
                }
                allChildren.addAll((Collection<EclipseProject>)eclipseProject.getChildren());
            }
            return null;
        }

        public String runTask(String taskName, IProgressMonitor monitor, List<String> args) throws Exception {
            return (String)this.build.withConnection(c -> {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ((BuildLauncher)((BuildLauncher)((BuildLauncher)c.newBuild().forTasks(new String[]{taskName}).withArguments((Iterable)args)).setStandardOutput((OutputStream)out)).setStandardError((OutputStream)out)).run();
                return new String(out.toByteArray());
            }, monitor);
        }

        private Collection<EclipseProject> fetchEclipseProjectModels(ModelProvider modelProvider) {
            try {
                Method fetchModelsMethod = modelProvider.getClass().getDeclaredMethod("fetchModels", Class.class, FetchStrategy.class, CancellationTokenSource.class, IProgressMonitor.class);
                Object models = fetchModelsMethod.invoke((Object)modelProvider, EclipseProject.class, FetchStrategy.LOAD_IF_NOT_CACHED, GradleConnector.newCancellationTokenSource(), new NullProgressMonitor());
                if (models instanceof Map) {
                    return ((Map)models).values();
                }
                return (Collection)models;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

