/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide;

import com.zeroturnaround.jrebel.ide.common.guide.metrics.SetupGuideMessenger;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.event.Event;
import org.zeroturnaround.eclipse.feature.guide.utils.E4BundleUtil;
import org.zeroturnaround.eclipse.feature.guide.utils.MPartUtil;
import org.zeroturnaround.eclipse.feature.guide.utils.MPerspectiveUtil;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;

public class OpenSetupGuideHandler
extends AbstractHandler {
    private static final Log log = Log.getInstance(OpenSetupGuideHandler.class);
    private static final int DELAY_IN_SECONDS = 1;
    private static final AtomicBoolean configOpenHandlerRegistered = new AtomicBoolean();

    public Object execute(ExecutionEvent executionEvent) {
        if (E4BundleUtil.isE4BundlesPresent()) {
            OpenSetupGuideHandler.openSetupGuide();
            GuideModel.getInstance().getMessenger().guideOpenedFromMenu();
        }
        return null;
    }

    static void closeAllSetupGuides() {
        if (!E4BundleUtil.isE4BundlesPresent()) {
            return;
        }
        EclipseUtil.runInUiThread(() -> {
            block10: {
                boolean modelServiceFailed = false;
                EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
                if (modelService == null) {
                    modelServiceFailed = true;
                    log.error("Unable to close Setup Guide since EModelService is null. Trying to close them using non-e4 apis.");
                } else {
                    List<MPart> setupGuideParts = MPartUtil.findParts(modelService, "org.zeroturnaround.eclipse.feature.guide.SetupGuideViewPart");
                    if (setupGuideParts.isEmpty()) {
                        modelServiceFailed = true;
                        log.warn("No Setup Guide views were found for closing. Trying to close them using non-e4 apis.");
                    } else {
                        for (MPart setupGuidePart : setupGuideParts) {
                            MPartUtil.closePart(modelService, setupGuidePart);
                        }
                    }
                }
                try {
                    IWorkbenchWindow[] windows;
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            IViewPart view = page.findView("org.zeroturnaround.eclipse.feature.guide.SetupGuideViewPart");
                            if (view != null) {
                                page.hideView(view);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    if (!modelServiceFailed) break block10;
                    log.warn("Failed to close active Setup Guide using non-e4 apis due to exception. {}", (Object)e.toString());
                }
            }
        });
    }

    static void scheduleSetupGuideOpen() {
        if (!E4BundleUtil.isE4BundlesPresent()) {
            return;
        }
        SetupGuideMessenger messenger = GuideModel.getInstance().getMessenger();
        if (GuideModel.getInstance().isGuideCompleted()) {
            log.info("Skipping setup guide as it was already completed");
            messenger.setGuideState(SetupGuideMessenger.OverallState.NOT_APPLICABLE);
        } else if (messenger.isDisabledInConfiguration()) {
            log.info("Skipping setup guide as it was disabled from configuration");
            messenger.guideDisabled();
            messenger.setGuideState(SetupGuideMessenger.OverallState.DISABLED_BY_FLAG);
        } else if (messenger.isDisabledFromUi()) {
            log.info("Skipping setup guide as it was disabled from ui");
        } else {
            if (OpenSetupGuideHandler.workspaceContainsNoJavaProjects()) {
                log.info("Setting setup guide state to NO_JAVA_PROJECTS as no Java projects were found");
                messenger.setGuideState(SetupGuideMessenger.OverallState.NO_JAVA_PROJECTS);
            }
            log.info("Schedule showing setup guide in {} seconds", (Object)1);
            messenger.guideScheduledToOpen();
            SharedScheduler.getExecutor().schedule(OpenSetupGuideHandler::openSetupGuide, 1L, TimeUnit.SECONDS);
        }
    }

    private static boolean workspaceContainsNoJavaProjects() {
        IProject[] iProjectArray = EclipseUtil.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectHelper.isJavaProject((IProject)project)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void openSetupGuide() {
        if (!E4BundleUtil.isE4BundlesPresent()) {
            return;
        }
        if (configOpenHandlerRegistered.compareAndSet(false, true)) {
            IEventBroker broker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
            broker.subscribe("org/eclipse/e4/ui/LifeCycle/perspOpened", OpenSetupGuideHandler::handlePerspectiveOpen);
        }
        EclipseUtil.runInUiThread(() -> {
            MPerspective perspective = MPerspectiveUtil.findCurrentlyVisiblePerspective();
            if (perspective != null) {
                try {
                    OpenSetupGuideHandler.showSetupGuideOnRightSideOfPerspective(perspective);
                }
                catch (Exception e) {
                    log.error("Failed to open Setup Guide due to exception.", (Throwable)e);
                }
            } else {
                log.error("Failed to find a perspective where to show the Setup Guide");
            }
        });
    }

    private static void handlePerspectiveOpen(Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPerspective)) {
            return;
        }
        SetupGuideMessenger messenger = GuideModel.getInstance().getMessenger();
        if (messenger.isDisabledFromUi() || messenger.isDisabledInConfiguration()) {
            return;
        }
        MPerspective perspective = (MPerspective)element;
        String id = perspective.getElementId();
        if (!(id.equals("org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective") || id.equals("org.eclipse.debug.ui.DebugPerspective") || id.equals("org.eclipse.jdt.ui.JavaPerspective") || id.equals("org.eclipse.jst.j2ee.J2EEPerspective"))) {
            return;
        }
        if (GuideModel.getInstance().isGuideCompleted()) {
            log.info("Perspective {} was opened but setup-guide is marked completed so not showing", (Object)id);
        } else {
            log.info("Perspective {} was opened, showing setup-guide", (Object)id);
            EclipseUtil.runInUiThread(() -> {
                try {
                    OpenSetupGuideHandler.showSetupGuideOnRightSideOfPerspective(perspective);
                }
                catch (Exception e) {
                    log.error("Failed to open Setup Guide due to exception.", (Throwable)e);
                }
            });
        }
    }

    private static void showSetupGuideOnRightSideOfPerspective(@NotNull MPerspective perspective) {
        MPart setupGuidePart;
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        if (modelService == null) {
            log.warn("Unable to show setup guide since EModelService is null.");
            return;
        }
        EPartService partService = MPartUtil.findWindowSpecificPartService(modelService, (MUIElement)perspective);
        if (partService == null) {
            log.warn("Unable to find window specific part service for perspective.");
            partService = (EPartService)PlatformUI.getWorkbench().getService(EPartService.class);
            if (partService == null) {
                log.warn("Unable to show Setup Guide since no EPartService was found.");
                return;
            }
        }
        if ((setupGuidePart = MPartUtil.findOrCreatePart(partService, "org.zeroturnaround.eclipse.feature.guide.SetupGuideViewPart")) == null) {
            log.error("Failed to find or create an MPart for SetupGuideViewPart");
            return;
        }
        MPartUtil.showPart(partService, setupGuidePart, EPartService.PartState.VISIBLE);
        if (!OpenSetupGuideHandler.partIsInRightSideOfPerspective(setupGuidePart, perspective)) {
            MPartUtil.movePartToEdgeOfPerspective(modelService, perspective, setupGuidePart, MPartUtil.PartLocation.RIGHT, 0.33f);
        }
    }

    private static boolean partIsInRightSideOfPerspective(@NotNull MPart setupGuidePart, @NotNull MPerspective perspective) {
        List containerChildren;
        MElementContainer setupGuideParentStack = MPartUtil.getParent((MUIElement)setupGuidePart);
        if (!(setupGuideParentStack instanceof MPartStack)) {
            return false;
        }
        MElementContainer setupGuideParentSashContainer = MPartUtil.getParent((MUIElement)setupGuideParentStack);
        if (!(setupGuideParentSashContainer instanceof MPartSashContainer)) {
            return false;
        }
        MPartSashContainer perspectiveSashContainer = MPerspectiveUtil.findPerspectiveSashContainer(perspective);
        if (perspectiveSashContainer != null && perspectiveSashContainer.equals(setupGuideParentSashContainer) && !(containerChildren = perspectiveSashContainer.getChildren()).isEmpty()) {
            MPartSashContainerElement lastChild = (MPartSashContainerElement)containerChildren.get(containerChildren.size() - 1);
            return setupGuideParentStack.equals(lastChild) && perspectiveSashContainer.isHorizontal();
        }
        return false;
    }
}

