/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide;

import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.jrebel.client.logger.Log;

class SetupGuideMenuEntryUtil {
    private static final Log log = Log.getInstance(SetupGuideMenuEntryUtil.class);

    SetupGuideMenuEntryUtil() {
    }

    static void addSetupGuideMenuEntry() {
        try {
            EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
            MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
            MMenu jrebelMenu = SetupGuideMenuEntryUtil.findJRebelMenu(modelService, application);
            if (jrebelMenu == null) {
                log.error("Failed to add Setup Guide to Help > JRebel since the menu was not found.");
                return;
            }
            MCommand openSetupGuideCommand = SetupGuideMenuEntryUtil.findOpenSetupGuideCommand(modelService, application);
            MHandledMenuItem setupGuideMenuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
            setupGuideMenuItem.setCommand(openSetupGuideCommand);
            setupGuideMenuItem.setLabel("Setup Guide");
            jrebelMenu.getChildren().add(setupGuideMenuItem);
        }
        catch (Exception e) {
            log.error("Failed to add Setup Guide to Help > JRebel due to exception.", (Throwable)e);
        }
    }

    @Nullable
    private static MMenu findJRebelMenu(EModelService modelService, MApplication application) {
        List menus = modelService.findElements((MUIElement)application, "org.zeroturnaround.eclipse.menus.jrebelHelpParentMenu", MMenu.class, null, 32);
        if (menus.isEmpty()) {
            return null;
        }
        return (MMenu)menus.get(0);
    }

    @NotNull
    private static MCommand findOpenSetupGuideCommand(EModelService modelService, MApplication application) {
        List commands = modelService.findElements((MUIElement)application, "org.zeroturnaround.eclipse.commands.openSetupGuide", MCommand.class, null, 29);
        if (commands.isEmpty()) {
            MCommand openSetupGuideCommand = (MCommand)modelService.createModelElement(MCommand.class);
            openSetupGuideCommand.setElementId("org.zeroturnaround.eclipse.commands.openSetupGuide");
            return openSetupGuideCommand;
        }
        return (MCommand)commands.get(0);
    }
}

