/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide;

import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModelStep;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.eclipse.feature.guide.UiDataProvider;
import org.zeroturnaround.eclipse.feature.guide.panels.GuideHeaderPanel;
import org.zeroturnaround.eclipse.feature.guide.panels.GuideSuccessPanel;
import org.zeroturnaround.eclipse.feature.guide.panels.StepPanel;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;

public class SetupGuideView
extends Composite {
    private final GuideHeaderPanel headerPanel;
    private final Composite stepsCompositePanel;
    private final List<StepPanel> stepPanels = new ArrayList<StepPanel>();
    private final Composite neverShowAgainStepsSection;
    private final Composite successSection;

    public SetupGuideView(Composite parent) {
        super(parent, 0);
        this.setBackground(UiDataProvider.getBackgroundColor());
        this.setData("org.eclipse.e4.ui.css.id", "SetupGuideView");
        this.initLayout();
        this.headerPanel = this.createHeaderSection();
        this.stepsCompositePanel = this.createStepsSection();
        this.neverShowAgainStepsSection = this.createNeverShowAgainSection();
        this.successSection = this.createSuccessPanel();
        this.showInstructions();
    }

    private void initLayout() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
    }

    private GuideHeaderPanel createHeaderSection() {
        GuideHeaderPanel headerPanel = new GuideHeaderPanel(this);
        headerPanel.setLayoutData(new GridData(4, 128, false, false));
        return headerPanel;
    }

    private Composite createStepsSection() {
        Composite stepsPanel = new Composite((Composite)this, 0);
        WidgetElement.setCSSClass((Widget)stepsPanel, (String)"steps");
        stepsPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        stepsPanel.setBackground(UiDataProvider.getBorderColor());
        GridLayout stepsLayout = new GridLayout(1, true);
        stepsLayout.marginHeight = 1;
        stepsLayout.marginWidth = 0;
        stepsLayout.verticalSpacing = 1;
        stepsPanel.setLayout((Layout)stepsLayout);
        for (GuideModelStep step : GuideModel.getInstance().getGuideModelSteps().values()) {
            StepPanel section = new StepPanel(stepsPanel, step);
            this.stepPanels.add(section);
            section.addHoverListener();
        }
        return stepsPanel;
    }

    private Composite createNeverShowAgainSection() {
        Composite dontShowAgainSection = new Composite((Composite)this, 0);
        dontShowAgainSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        dontShowAgainSection.setBackground(UiDataProvider.getBackgroundColor());
        GridLayout dontShowAgainLayout = new GridLayout(1, false);
        dontShowAgainLayout.marginLeft = 20;
        dontShowAgainLayout.marginRight = 20;
        dontShowAgainLayout.marginTop = 30;
        dontShowAgainLayout.marginBottom = 0;
        dontShowAgainLayout.marginWidth = 0;
        dontShowAgainLayout.marginHeight = 0;
        dontShowAgainSection.setLayout((Layout)dontShowAgainLayout);
        StyledText dontShowAgainLink = UiDataProvider.dontShowAgainLink(dontShowAgainSection);
        dontShowAgainLink.setBackground(UiDataProvider.getBackgroundColor());
        return dontShowAgainSection;
    }

    private Composite createSuccessPanel() {
        Composite borderedComposite = new Composite((Composite)this, 0);
        GridLayout successLayout = new GridLayout(1, true);
        successLayout.marginTop = 1;
        successLayout.marginHeight = 0;
        successLayout.marginWidth = 0;
        borderedComposite.setLayout((Layout)successLayout);
        borderedComposite.setBackground(UiDataProvider.getBorderColor());
        borderedComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GuideSuccessPanel successPanel = new GuideSuccessPanel(borderedComposite);
        successPanel.setLayoutData(new GridData(4, 4, true, true));
        return borderedComposite;
    }

    private void showSuccessPanel() {
        SWTUtil.setCompositeVisiblity((Composite)this.headerPanel, (boolean)true);
        SWTUtil.setCompositeVisiblity((Composite)this.stepsCompositePanel, (boolean)false);
        SWTUtil.setCompositeVisiblity((Composite)this.neverShowAgainStepsSection, (boolean)false);
        SWTUtil.setCompositeVisiblity((Composite)this.successSection, (boolean)true);
    }

    private void showInstructions() {
        GuideModel model = GuideModel.getInstance();
        SWTUtil.setCompositeVisiblity((Composite)this.headerPanel, (boolean)true);
        SWTUtil.setCompositeVisiblity((Composite)this.stepsCompositePanel, (boolean)true);
        SWTUtil.setCompositeVisiblity((Composite)this.neverShowAgainStepsSection, (boolean)true);
        SWTUtil.setCompositeVisiblity((Composite)this.successSection, (boolean)false);
        this.headerPanel.setPostInstallationLabelVisibility(model.isAfterInstallation());
        for (StepPanel section : this.stepPanels) {
            section.refresh(model);
        }
    }

    void refreshView(boolean requestSuccessPanel) {
        EclipseUtil.runInUiThread(() -> {
            if (!this.isDisposed()) {
                if (requestSuccessPanel) {
                    this.showSuccessPanel();
                } else {
                    this.showInstructions();
                }
                this.pack(true);
            }
        });
    }
}

