/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide;

import com.zeroturnaround.jrebel.ide.common.guide.metrics.SetupGuideMessenger;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.zeroturnaround.eclipse.feature.guide.SetupGuideView;
import org.zeroturnaround.eclipse.feature.guide.UiDataProvider;

public class SetupGuideViewPart
extends ViewPart {
    public static final String VIEW_PART_ID = "org.zeroturnaround.eclipse.feature.guide.SetupGuideViewPart";
    public static final String COMMAND_ID = "org.zeroturnaround.eclipse.commands.openSetupGuide";
    public static final String HANDLER_ID = "org.zeroturnaround.eclipse.feature.guide.OpenSetupGuideHandler";
    private final GuideModel.Listener guideChangeListener = this::refreshView;
    private SetupGuideView setupGuideView;

    public void createPartControl(Composite partParent) {
        partParent.setLayout((Layout)new FillLayout());
        partParent.setBackground(UiDataProvider.getBackgroundColor());
        this.setupGuideView = this.createScrollableSetupGuideView(partParent);
        GuideModel.getInstance().addListener(this.guideChangeListener);
        this.refreshView(false);
        this.notifyGuideOpenend();
    }

    private SetupGuideView createScrollableSetupGuideView(Composite partParent) {
        ScrolledComposite sc = new ScrolledComposite(partParent, 768);
        sc.setBackground(UiDataProvider.getBackgroundColor());
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        SetupGuideView setupGuideView = new SetupGuideView((Composite)sc);
        sc.setContent((Control)setupGuideView);
        return setupGuideView;
    }

    private void notifyGuideOpenend() {
        SetupGuideMessenger messenger = GuideModel.getInstance().getMessenger();
        messenger.incrementOpenCount();
        messenger.guideOpened();
        messenger.setGuideState(SetupGuideMessenger.OverallState.SHOWN);
    }

    private void notifyGuideClosed() {
        SetupGuideMessenger messenger = GuideModel.getInstance().getMessenger();
        messenger.decrementOpenCount();
        messenger.guideClosed();
        messenger.setGuideState(SetupGuideMessenger.OverallState.CLOSED);
    }

    private void refreshView(boolean requestSuccessPanel) {
        this.setupGuideView.refreshView(requestSuccessPanel);
    }

    public void dispose() {
        GuideModel.getInstance().removeListener(this.guideChangeListener);
        super.dispose();
        this.setupGuideView.dispose();
        this.notifyGuideClosed();
    }

    public void setFocus() {
    }
}

