/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide;

import com.zeroturnaround.jrebel.ide.common.guide.metrics.SetupGuideMessenger;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.config.ui.newactivation.ActivationDialogNew;
import org.zeroturnaround.eclipse.feature.guide.OpenSetupGuideHandler;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;
import org.zeroturnaround.eclipse.ui.swt.StyledTextBuilder;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;

public class UiDataProvider {
    public static final String MARK_AS_COMPLETE_TEXT = "Mark as complete";
    public static final int LEFT_MARGIN = 20;
    public static final int RIGHT_MARGIN = 20;
    public static final int LOGO_TOP_PADDING = 30;
    public static final int LOGO_BOTTOM_PADDING = 20;
    public static final int LOGO_SPACING = 20;
    public static final int STEP_HEADER_TOP_PADDING = 15;
    public static final int STEP_HEADER_BOTTOM_PADDING = 15;
    public static final int STEP_CONTENT_TOP_PADDING = 0;
    public static final int STEP_CONTENT_BOTTOM_PADDING = 15;
    public static final int STEP_CONTENT_SPACING = 5;
    public static final int STEP_ERROR_CONTENT_MARGIN_WIDTH = 13;
    public static final int STEP_ERROR_CONTENT_MARGIN_HEIGHT = 11;
    public static final int DONT_SHOW_LINK_TOP_PADDING = 30;
    public static final int DONT_SHOW_LINK_BOTTOM_PADDING = 0;
    public static final RGB STEP_ERROR_BACKGROUND_RGB = new RGB(242, 222, 222);
    public static final RGB STEP_ERROR_BORDER_RGB = new RGB(238, 211, 215);
    public static final RGB STEP_ERROR_TEXT_RGB = new RGB(185, 74, 72);

    private UiDataProvider() {
    }

    public static Color getBackgroundColor() {
        return Display.getDefault().getSystemColor(25);
    }

    public static Color getBorderColor() {
        return Display.getDefault().getSystemColor(18);
    }

    public static Color getStepHoveredColor() {
        return Display.getDefault().getSystemColor(22);
    }

    public static Color getStepSelectedColor() {
        return Display.getDefault().getSystemColor(22);
    }

    public static String getStepTooltipState(GuideModel.Step step, GuideModel.StepState stepState) {
        if (step == GuideModel.Step.RELOAD) {
            switch (stepState) {
                case LOCKED: {
                    return "Complete previous steps to proceed (mark as complete if they are done)";
                }
            }
            return null;
        }
        return null;
    }

    public static Label addHeaderTo(Composite composite, GuideModel.Step step) {
        Label label = new Label(composite, 0);
        label.setFont(UiDataProvider.createBigFont(label.getFont()));
        switch (step) {
            case ACTIVATE: {
                label.setText("Activate JRebel");
                break;
            }
            case PROJECT_CONFIGURATION: {
                label.setText("Project configuration");
                break;
            }
            case STARTUP_CONFIGURATION: {
                label.setText("Startup configuration");
                break;
            }
            case RELOAD: {
                label.setText("Reload your code");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(step));
            }
        }
        return label;
    }

    public static Composite addInstructionsTo(Composite composite, GuideModel.Step step) {
        switch (step) {
            case ACTIVATE: {
                return UiDataProvider.addActivateInstructionsTo(composite);
            }
            case PROJECT_CONFIGURATION: {
                return UiDataProvider.addProjectConfigurationInstructionsTo(composite);
            }
            case STARTUP_CONFIGURATION: {
                return UiDataProvider.addStartupConfigurationInstructionsTo(composite);
            }
            case RELOAD: {
                return UiDataProvider.addReloadYourCodeInstructionsTo(composite);
            }
        }
        throw new IllegalArgumentException(String.valueOf(step));
    }

    private static Composite addActivateInstructionsTo(Composite composite) {
        Runnable listener = () -> {
            LicensingStatus status = Watcher.getInstance().getLastLicensingStatus();
            ActivationDialogNew dialog = new ActivationDialogNew(Display.getCurrent().getActiveShell(), status);
            dialog.open();
        };
        StyledText styledText = new StyledTextBuilder().appendText("Open ").appendLink("JRebel Activation", listener).appendText(" to enter your license or start a new trial.").build(composite, 64);
        UiDataProvider.setSmallFont((Canvas)styledText);
        return styledText;
    }

    private static Composite addProjectConfigurationInstructionsTo(Composite composite) {
        StyledText styledText = new StyledTextBuilder().appendText("1. Open ").appendBoldText("Help > JRebel > Configuration > ").appendLink("Projects", JRebelConfigCenterProxy::openConfigCenterProjectsPage).appendText(".").newLine().appendText("2. Enable JRebel for your projects.").newLine().appendText("3. Redeploy your application.").newParagraph().appendText("Enabling JRebel for your projects maps them to the deployed application to allow reloads.").build(composite, 64);
        UiDataProvider.setSmallFont((Canvas)styledText);
        return styledText;
    }

    private static Composite addStartupConfigurationInstructionsTo(Composite composite) {
        StyledText styledText = new StyledTextBuilder().appendText("JRebel is enabled by default for application servers that are started from the IDE.").newParagraph().appendText("Review settings at ").appendBoldText("Help > JRebel > Configuration > ").appendLink("Startup", JRebelConfigCenterProxy::openConfigCenterStartupPage).appendText(".").newParagraph().appendText("If you run your servers from ").appendLink("command line", JRebelConfigCenterProxy::openConfigCenterStartupPageWithCLI).appendText(" or ").appendLink("remotely", JRebelConfigCenterProxy::openConfigCenterStartupPageWithRemote).appendText(", follow the embedded instructions.").build(composite, 64);
        UiDataProvider.setSmallFont((Canvas)styledText);
        return styledText;
    }

    private static Composite addReloadYourCodeInstructionsTo(Composite composite) {
        StyledText styledText = new StyledTextBuilder().appendText("1. Make sure ").appendBoldText("Project > Build Automatically").appendText(" is enabled.").newLine().appendText("2. Change something in the application code and save.").newLine().appendText("3. Refresh the application in the browser to see the changes!").build(composite, 64);
        UiDataProvider.setSmallFont((Canvas)styledText);
        return styledText;
    }

    @Nullable
    public static Composite addMoreInformationLink(Composite composite, GuideModel.Step step) {
        switch (step) {
            case PROJECT_CONFIGURATION: {
                StyledText styledText = new StyledTextBuilder().appendLink("More information", () -> UiDataProvider.openLinkInThread("https://www.jrebel.com/products/jrebel/quickstart/eclipse?run=ide#project-configuration")).build(composite, 64);
                UiDataProvider.setSmallFont((Canvas)styledText);
                return styledText;
            }
            case STARTUP_CONFIGURATION: {
                StyledText styledText = new StyledTextBuilder().appendLink("More information", () -> UiDataProvider.openLinkInThread("https://www.jrebel.com/products/jrebel/quickstart/eclipse?run=ide#server-configuration")).build(composite, 64);
                UiDataProvider.setSmallFont((Canvas)styledText);
                return styledText;
            }
        }
        return null;
    }

    private static void setSmallFont(Canvas canvas) {
        canvas.setFont(UiDataProvider.createSmallFont(canvas.getFont()));
    }

    public static Font createSmallFont(Font oldFont) {
        return FontDescriptor.createFrom((Font)oldFont).increaseHeight(-1).createFont(oldFont.getDevice());
    }

    public static Font createBigFont(Font oldFont) {
        return FontDescriptor.createFrom((Font)oldFont).increaseHeight(1).createFont(oldFont.getDevice());
    }

    private static void openLinkInThread(String href) {
        BrowserUtil.silentOpenLink((String)href);
    }

    public static StyledText dontShowAgainLink(Composite composite) {
        StyledText styledText = new StyledTextBuilder().appendLink("Don\u2019t show the setup guide again", UiDataProvider::neverShowSetupGuideAgain).build(composite, 64);
        UiDataProvider.setSmallFont((Canvas)styledText);
        return styledText;
    }

    private static void neverShowSetupGuideAgain() {
        SetupGuideMessenger messenger = GuideModel.getInstance().getMessenger();
        messenger.guideDisabledUi();
        messenger.setGuideState(SetupGuideMessenger.OverallState.DISABLED_FROM_UI);
        OpenSetupGuideHandler.closeAllSetupGuides();
    }
}

