/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide.panels;

import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModelStep;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.services.IDisposable;
import org.zeroturnaround.eclipse.feature.guide.UiDataProvider;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;

public class StepPanel
extends Composite
implements IDisposable {
    private GuideModelStep step;
    private Composite headerSection;
    private Composite bodySection;
    private Label expandLabel;
    private Composite markAsCompleteSection;
    private boolean hovered;
    private Composite errorSection;
    private final List<Resource> disposables = new ArrayList<Resource>();

    public StepPanel(Composite parent, final GuideModelStep step) {
        super(parent, 0);
        this.step = step;
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setBackgroundMode(2);
        this.createHeaderSection();
        this.createBodySection();
        this.addHeader(step);
        this.addErrorSection(step);
        this.addInstructions(step);
        if (step.isCanMarkAsComplete()) {
            this.addMarkAsComplete();
        }
        this.addToggleListenerToHeaderSection((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                step.clickedOn();
            }
        });
    }

    private void addErrorSection(GuideModelStep step) {
        if (step.getErrorText() != null) {
            this.errorSection = new Composite(this.bodySection, 0);
            this.errorSection.setLayoutData((Object)new GridData(4, 128, false, false));
            this.errorSection.setBackground(this.disposeLater(new Color((Device)Display.getCurrent(), UiDataProvider.STEP_ERROR_BORDER_RGB)));
            GridLayout errorSectionBorderLayout = new GridLayout(1, true);
            errorSectionBorderLayout.marginHeight = 1;
            errorSectionBorderLayout.marginWidth = 1;
            this.errorSection.setLayout((Layout)errorSectionBorderLayout);
            WidgetElement.setCSSClass((Widget)this.errorSection, (String)"error");
            Composite errorContentsSection = new Composite(this.errorSection, 0);
            GridLayout errorContentsLayout = new GridLayout(1, false);
            errorContentsLayout.marginWidth = 13;
            errorContentsLayout.marginHeight = 11;
            errorContentsSection.setLayout((Layout)errorContentsLayout);
            errorContentsSection.setLayoutData((Object)new GridData(4, 128, true, true));
            errorContentsSection.setBackground(this.disposeLater(new Color((Device)Display.getCurrent(), UiDataProvider.STEP_ERROR_BACKGROUND_RGB)));
            Label label = new Label(errorContentsSection, 0);
            label.setText(step.getErrorText());
            label.setForeground(this.disposeLater(new Color((Device)Display.getCurrent(), UiDataProvider.STEP_ERROR_TEXT_RGB)));
            label.setFont(UiDataProvider.createSmallFont(label.getFont()));
        }
    }

    public void refresh(GuideModel model) {
        if (model.isOpened(this.step.getStep())) {
            WidgetElement.setCSSClass((Widget)this, (String)"opened");
        } else if (this.hovered) {
            WidgetElement.setCSSClass((Widget)this, (String)"hovered");
        } else {
            WidgetElement.setCSSClass((Widget)this, (String)"");
        }
        switch (this.step.getState()) {
            case LOCKED: {
                this.locked();
                break;
            }
            case AVAILABLE: {
                this.available(model);
                break;
            }
            case DONE: {
                this.completed(model);
                break;
            }
            case ERROR: {
                this.error(model);
            }
        }
        String tooltip = UiDataProvider.getStepTooltipState(this.step.getStep(), this.step.getState());
        this.setTooltipRecursive((Control)this.headerSection, tooltip);
        WidgetElement.applyStyles((Widget)this, (boolean)true);
    }

    public void setExpanded(boolean expanded) {
        ((GridData)this.bodySection.getLayoutData()).exclude = !expanded;
    }

    public boolean isExpanded() {
        return !((GridData)this.bodySection.getLayoutData()).exclude;
    }

    public void addToggleListenerToHeaderSection(MouseListener listener) {
        this.addMouseListenerRecursively(listener, this.headerSection);
    }

    private void addMouseListenerRecursively(MouseListener listener, Composite composite) {
        composite.addMouseListener(listener);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.addMouseListenerRecursively(listener, (Composite)c);
            } else {
                c.addMouseListener(listener);
            }
            ++n2;
        }
    }

    public void addHoverListener() {
        MouseTrackAdapter listener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (!this.isInside(StepPanel.this, e)) {
                    StepPanel.this.hovered = false;
                    StepPanel.this.refresh(GuideModel.getInstance());
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (this.isInside(StepPanel.this, e)) {
                    StepPanel.this.hovered = true;
                    StepPanel.this.refresh(GuideModel.getInstance());
                }
            }

            private boolean isInside(Composite wrapper, MouseEvent e) {
                Point widgetLocationRelatedToRoot = this.getRelativeLocation(wrapper, (Control)e.widget);
                Point realLoc = new Point(widgetLocationRelatedToRoot.x + e.x, widgetLocationRelatedToRoot.y + e.y);
                return realLoc.x > 0 && realLoc.y > 0 && realLoc.x < wrapper.getSize().x && realLoc.y < wrapper.getSize().y;
            }

            private Point getRelativeLocation(Composite wrapper, Control control) {
                if (control == null) {
                    return new Point(0, 0);
                }
                if (wrapper == control.getParent()) {
                    return control.getLocation();
                }
                Point location = this.getRelativeLocation(wrapper, (Control)control.getParent());
                Point cur = control.getLocation();
                return new Point(location.x + cur.x, location.y + cur.y);
            }
        };
        this.addMouseTrackListenerRecursively((MouseTrackListener)listener, this);
    }

    private void addMouseTrackListenerRecursively(MouseTrackListener listener, Composite composite) {
        composite.addMouseTrackListener(listener);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.addMouseTrackListenerRecursively(listener, (Composite)c);
            } else {
                c.addMouseTrackListener(listener);
            }
            ++n2;
        }
    }

    private void locked() {
        this.expandLabel.setImage(RebelImage.STEP_LOCKED.getImage());
        this.setExpanded(false);
    }

    private void completed(GuideModel model) {
        this.expandLabel.setImage(RebelImage.STEP_COMPLETED.getImage());
        this.showMarkAsCompletedButton(false);
        this.setExpanded(model.isOpened(this.step.getStep()));
        if (this.errorSection != null) {
            SWTUtil.setCompositeVisiblity((Composite)this.errorSection, (boolean)false);
        }
    }

    private void available(GuideModel model) {
        this.showMarkAsCompletedButton(true);
        if (model.isOpened(this.step.getStep())) {
            this.expandLabel.setImage(RebelImage.STEP_EXPANDED.getImage());
            this.setExpanded(true);
        } else {
            this.expandLabel.setImage(RebelImage.STEP_COLLAPSED.getImage());
            this.setExpanded(false);
        }
        if (this.errorSection != null) {
            SWTUtil.setCompositeVisiblity((Composite)this.errorSection, (boolean)false);
        }
    }

    private void showMarkAsCompletedButton(boolean visible) {
        if (this.markAsCompleteSection != null) {
            this.markAsCompleteSection.setVisible(visible);
            Object layoutData = this.markAsCompleteSection.getLayoutData();
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).exclude = !visible;
            }
        }
    }

    private void error(GuideModel model) {
        this.expandLabel.setImage(RebelImage.STEP_ERROR.getImage());
        this.showMarkAsCompletedButton(false);
        this.setExpanded(model.isOpened(this.step.getStep()));
        if (this.errorSection != null) {
            SWTUtil.setCompositeVisiblity((Composite)this.errorSection, (boolean)true);
        }
    }

    private Composite createHeaderSection() {
        this.headerSection = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 15;
        layout.marginBottom = 15;
        this.headerSection.setLayout((Layout)layout);
        this.headerSection.setLayoutData((Object)new GridData(4, 128, true, false));
        this.headerSection.setCursor(Display.getCurrent().getSystemCursor(21));
        return this.headerSection;
    }

    private Composite addHeader(GuideModelStep step) {
        Composite wrapper = new Composite(this.headerSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        wrapper.setLayout((Layout)layout);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite left = new Composite(wrapper, 0);
        GridLayout leftLayout = new GridLayout(1, false);
        leftLayout.marginWidth = 0;
        leftLayout.marginHeight = 0;
        left.setLayout((Layout)leftLayout);
        left.setLayoutData((Object)new GridData(4, 128, true, false));
        Label headerLabel = UiDataProvider.addHeaderTo(left, step.getStep());
        headerLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite right = new Composite(wrapper, 0);
        GridLayout rightLayout = new GridLayout(1, false);
        rightLayout.marginWidth = 0;
        rightLayout.marginHeight = 0;
        right.setLayout((Layout)rightLayout);
        right.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.expandLabel = new Label(right, 0);
        this.expandLabel.setFont(UiDataProvider.createBigFont(this.expandLabel.getFont()));
        this.locked();
        return wrapper;
    }

    private Composite createBodySection() {
        this.bodySection = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 15;
        layout.verticalSpacing = 5;
        this.bodySection.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 128, true, true);
        layoutData.exclude = true;
        this.bodySection.setLayoutData((Object)layoutData);
        return this.bodySection;
    }

    private void addInstructions(GuideModelStep step) {
        Composite wrapper = new Composite(this.bodySection, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wrapper.setLayout((Layout)layout);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite instructionsComposite = UiDataProvider.addInstructionsTo(wrapper, step.getStep());
        instructionsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void addMarkAsComplete() {
        Composite wrapper = new Composite(this.bodySection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        wrapper.setLayout((Layout)layout);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, false));
        this.markAsCompleteSection = new Composite(wrapper, 0);
        GridLayout leftLayout = new GridLayout(1, false);
        leftLayout.marginWidth = 0;
        leftLayout.marginHeight = 0;
        this.markAsCompleteSection.setLayout((Layout)leftLayout);
        this.markAsCompleteSection.setLayoutData((Object)new GridData(16384, 128, true, false));
        Button markAsComplete = new Button(this.markAsCompleteSection, 0);
        markAsComplete.setText("Mark as complete");
        markAsComplete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StepPanel.this.step.markCompleted();
            }
        });
        Composite right = new Composite(wrapper, 0);
        GridLayout rightLayout = new GridLayout(1, false);
        rightLayout.marginWidth = 0;
        rightLayout.marginHeight = 0;
        right.setLayout((Layout)rightLayout);
        right.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Composite moreInformationLink = UiDataProvider.addMoreInformationLink(right, this.step.getStep());
        if (moreInformationLink != null) {
            moreInformationLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        }
    }

    private <T extends Resource> T disposeLater(T res) {
        if (res != null) {
            this.disposables.add(res);
        }
        return res;
    }

    public void dispose() {
        for (Resource disposable : this.disposables) {
            disposable.dispose();
        }
        super.dispose();
    }

    private void setTooltipRecursive(Control control, String tooltip) {
        if (control != null) {
            control.setToolTipText(tooltip);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.setTooltipRecursive(child, tooltip);
                    ++n2;
                }
            }
        }
    }
}

