/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide.utils;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.zeroturnaround.jrebel.client.logger.Log;

public final class E4BundleUtil {
    private static final Log log = Log.getInstance(E4BundleUtil.class);
    private static final List<String> REQUIRED_CLASSES = Arrays.asList("org.eclipse.e4.ui.model.application.ui.advanced.MPerspective", "org.eclipse.e4.ui.model.application.ui.basic.MPart", "org.eclipse.e4.ui.model.application.ui.basic.MPartStack", "org.eclipse.e4.ui.model.application.ui.basic.MStackElement", "org.eclipse.e4.ui.model.application.ui.basic.MWindow", "org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl", "org.eclipse.e4.ui.workbench.modeling.EModelService", "org.eclipse.e4.ui.workbench.modeling.EPartService", "org.eclipse.e4.ui.model.application.commands.MCommand", "org.eclipse.e4.ui.model.application.MApplication", "org.eclipse.e4.ui.model.application.ui.menu.MMenu");
    private static final boolean REQUIRED_CLASSES_PRESENT = E4BundleUtil.requiredClassesPresent();

    private static boolean requiredClassesPresent() {
        for (String requiredClass : REQUIRED_CLASSES) {
            try {
                Class.forName(requiredClass);
            }
            catch (ClassNotFoundException e) {
                log.error("Disabling OpenSetupGuideHandler from showing Setup Guide since one of the required classes '{}' is missing from classpath", (Object)requiredClass, (Object)e);
                return false;
            }
        }
        return true;
    }

    public static boolean isE4BundlesPresent() {
        return REQUIRED_CLASSES_PRESENT && E4BundleUtil.canFindHandlerForSetupGuide();
    }

    private static boolean canFindHandlerForSetupGuide() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand("org.zeroturnaround.eclipse.commands.openSetupGuide");
            return command != null && command.getHandler() != null;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

