/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.eclipse.feature.guide.utils.MPerspectiveUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class MPartUtil {
    private static final Log log = Log.getInstance(MPartUtil.class);

    @Nullable
    public static MPart findOrCreatePart(@NotNull EPartService partService, @NotNull String viewId) {
        MPart part = partService.findPart(viewId);
        if (part == null) {
            part = partService.createPart(viewId);
        }
        return part;
    }

    @NotNull
    public static List<MPart> findParts(@NotNull EModelService modelService, @Nullable String viewId) {
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        if (application != null) {
            return modelService.findElements((MUIElement)application, viewId, MPart.class, null, 29);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static MElementContainer getParent(@NotNull MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent != null) {
            return parent;
        }
        MPlaceholder sharedRef = element.getCurSharedRef();
        if (sharedRef != null) {
            return sharedRef.getParent();
        }
        return null;
    }

    public static void showPart(@NotNull EPartService partService, @NotNull MPart part, @NotNull EPartService.PartState partState) {
        if (!part.isVisible()) {
            part.setVisible(true);
        }
        partService.showPart(part, partState);
    }

    public static void closePart(@NotNull EModelService modelService, @NotNull MPart part) {
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = modelService.getContainingContext((MUIElement)part);
        IEclipseContext context = partContext == null ? parentContext : partContext;
        EPartService partService = (EPartService)context.get(EPartService.class);
        if (partService != null) {
            MElementContainer parent;
            partService.hidePart(part);
            MPart toBeRemoved = part;
            MPlaceholder sharedRef = part.getCurSharedRef();
            if (sharedRef != null) {
                toBeRemoved = sharedRef;
            }
            if ((parent = MPartUtil.getParent((MUIElement)toBeRemoved)) != null) {
                toBeRemoved.setToBeRendered(false);
                parent.getChildren().remove(toBeRemoved);
            }
        }
    }

    public static void movePartToEdgeOfPerspective(@NotNull EModelService modelService, @NotNull MPerspective perspective, @NotNull MPart part, @NotNull PartLocation location, float ratio) {
        MPartSashContainer perspectiveSashContainer = MPerspectiveUtil.findPerspectiveSashContainer(perspective);
        if (perspectiveSashContainer == null) {
            log.error("Cannot move part to the edge of perspective since MPartSashContainer can't be found for the perspective.");
            return;
        }
        MPlaceholder sharedRef = part.getCurSharedRef();
        MPlaceholder mStackElement = sharedRef != null ? sharedRef : part;
        MPartStack newStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        newStack.getChildren().add(mStackElement);
        newStack.setSelectedElement((MUIElement)mStackElement);
        modelService.insert((MPartSashContainerElement)newStack, (MPartSashContainerElement)perspectiveSashContainer, location.relationToPerspective, ratio);
    }

    @Nullable
    public static EPartService findWindowSpecificPartService(@NotNull EModelService modelService, @NotNull MUIElement element) {
        IEclipseContext context;
        MWindow window = modelService.getTopLevelWindowFor(element);
        if (window != null && (context = window.getContext()) != null) {
            return (EPartService)context.get(EPartService.class);
        }
        return null;
    }

    public static enum PartLocation {
        ABOVE(0),
        BELOW(1),
        LEFT(2),
        RIGHT(3);

        private final int relationToPerspective;

        private PartLocation(int relationToPerspective) {
            this.relationToPerspective = relationToPerspective;
        }
    }
}

