/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.feature.guide.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.eclipse.feature.guide.utils.E4BundleUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class MPerspectiveUtil {
    private static final Log log = Log.getInstance(MPerspectiveUtil.class);

    @Nullable
    public static MPartSashContainer findPerspectiveSashContainer(@NotNull MPerspective perspective) {
        MPartSashContainerElement perspectiveChild;
        if (!perspective.getChildren().isEmpty() && (perspectiveChild = (MPartSashContainerElement)perspective.getChildren().get(0)) instanceof MPartSashContainer) {
            return (MPartSashContainer)perspectiveChild;
        }
        return null;
    }

    @Nullable
    public static MPerspective findCurrentlyVisiblePerspective() {
        if (!E4BundleUtil.isE4BundlesPresent()) {
            return null;
        }
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        if (modelService == null) {
            log.warn("Unable to find currently visible perspective since EModelService is null.");
            return null;
        }
        MPerspective perspective = MPerspectiveUtil.findActivePerspective(modelService);
        if (perspective != null) {
            log.info("Found active perspective: {}", (Object)perspective);
            return perspective;
        }
        List<MPerspective> perspectives = MPerspectiveUtil.findAllPerspectives(modelService);
        perspective = MPerspectiveUtil.findSelectedPerspective(perspectives);
        if (perspective != null) {
            log.info("Found selected perspective: {}", (Object)perspective);
            return perspective;
        }
        if (!perspectives.isEmpty()) {
            perspective = perspectives.iterator().next();
            log.warn("Unable to find active or selected perspective. Returning random perspective: {}", (Object)perspective);
            return perspective;
        }
        log.error("No perspective found.");
        return null;
    }

    @Nullable
    private static MPerspective findSelectedPerspective(@NotNull List<MPerspective> perspectives) {
        for (MPerspective perspective : perspectives) {
            MUIElement selectedPerspective;
            MElementContainer perspectiveParent = perspective.getParent();
            if (perspectiveParent == null || !perspective.equals(selectedPerspective = perspectiveParent.getSelectedElement())) continue;
            return perspective;
        }
        return null;
    }

    @Nullable
    private static MPerspective findActivePerspective(@NotNull EModelService modelService) {
        if (!E4BundleUtil.isE4BundlesPresent()) {
            return null;
        }
        EPartService partService = (EPartService)PlatformUI.getWorkbench().getService(EPartService.class);
        if (partService == null) {
            log.warn("Unable to find active perspective since EPartService is null.");
            return null;
        }
        try {
            MWindow window;
            MPart activePart = partService.getActivePart();
            if (activePart != null && (window = modelService.getTopLevelWindowFor((MUIElement)activePart)) != null) {
                return modelService.getActivePerspective(window);
            }
        }
        catch (IllegalStateException e) {
            log.error("Unable to find active perspective due to exception. {}", (Object)e.toString());
        }
        return null;
    }

    @NotNull
    private static List<MPerspective> findAllPerspectives(@NotNull EModelService modelService) {
        if (E4BundleUtil.isE4BundlesPresent()) {
            MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
            if (application != null) {
                return modelService.findElements((MUIElement)application, null, MPerspective.class, null, 29);
            }
            log.warn("Unable to find all perspectives since MApplication is null.");
        }
        return Collections.emptyList();
    }
}

