/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.EclipseIdeInstance;
import org.zeroturnaround.eclipse.dialog.MetricsConsentDialog;
import org.zeroturnaround.eclipse.dialog.TimeSavedDialog;
import org.zeroturnaround.eclipse.hybris.HybrisDetectionFeature;
import org.zeroturnaround.eclipse.jrebel.EclipseJRebelClientAdapter;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNatureFeature;
import org.zeroturnaround.eclipse.notifications.EclipseRenderer;
import org.zeroturnaround.eclipse.projectpath.EclipseProjectPathListener;
import org.zeroturnaround.eclipse.update.EclipsePluginLatestVersionProvider;
import org.zeroturnaround.eclipse.util.EclipseMetricsUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.preferences.util.StringPreference;
import org.zeroturnaround.javarebel.reporting.util.WorkspaceCountPreferenceUtil;
import org.zeroturnaround.jrebel.client.metrics.MetricsConsent;
import org.zeroturnaround.jrebel.client.metrics.TimeSavedDialogTrigger;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;
import org.zeroturnaround.jrebel.client.update.PluginLatestVersionProvider;
import org.zeroturnaround.jrebel.ide.common.CommonStartup;
import org.zeroturnaround.jrebel.ide.common.notifications.UserNotificationRenderer;

public class EclipseCommonStartup
extends CommonStartup {
    private final UserNotificationRenderer renderer = new EclipseRenderer();
    private final EclipsePluginLatestVersionProvider versionProvider = new EclipsePluginLatestVersionProvider();

    protected void performNeededMigrations(boolean firstInstall) {
        super.performNeededMigrations(firstInstall);
        AutoEnableNatureFeature.migration(firstInstall);
    }

    public void start() {
        super.start();
        this.saveWorkspaceHashToPrefs();
    }

    @NotNull
    protected UserNotificationRenderer getUserNotificationRenderer() {
        return this.renderer;
    }

    protected void initJRebelClientAdapter() {
        EclipseJRebelClientAdapter.init();
    }

    @NotNull
    protected IdeInstance createAndGetIdeInstance() {
        return new EclipseIdeInstance();
    }

    protected void showMetricsConsentDialog(MetricsConsent.DialogResultCallback callback) {
        EclipseUtil.runInUiThread(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean dialogResult = MetricsConsentDialog.open(shell);
            callback.onResult(dialogResult);
        });
    }

    protected PluginLatestVersionProvider getPluginLatestVersionProvider() {
        return this.versionProvider;
    }

    protected void initTimeSavedDialog() {
        TimeSavedDialogTrigger.DialogResultProvider provider = callback -> EclipseUtil.runInUiThread(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean dialogResult = TimeSavedDialog.open(shell);
            callback.onResult(dialogResult);
        });
        TimeSavedDialogTrigger.init((TimeSavedDialogTrigger.DialogResultProvider)provider);
    }

    protected void startFrameworkDetection() {
        new HybrisDetectionFeature().startHybrisRebelXmlExclusionDetection();
    }

    protected void startProjectPathListener() {
        new EclipseProjectPathListener().startListener();
    }

    protected void initLicenseNotifier() {
    }

    private void saveWorkspaceHashToPrefs() {
        if (EclipseUtil.getWorkspaceJavaProjectsCount() == 0) {
            return;
        }
        PreferencesWrapper prefs = PreferencesWrapper.getInstance();
        StringPreference stringPref = prefs.getStringPref("ide.eclipse.workspace.count", "");
        Map workspacesLastUsed = WorkspaceCountPreferenceUtil.parseWorkspacesLastUsed((String)stringPref.getValue());
        workspacesLastUsed.put(EclipseMetricsUtil.getWorkspaceLocationHash(), System.currentTimeMillis());
        prefs.getPrefs().put("ide.eclipse.workspace.count", WorkspaceCountPreferenceUtil.convertWorkspacesLastUsedToString((Map)workspacesLastUsed));
    }
}

