/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.ide.common.IdeStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.Log;

public class EclipseIdeProject
extends IdeModule {
    private static final Log log = Log.getInstance(EclipseIdeProject.class);
    private final IProject project;
    private IdeStorage ideProjectStorage;
    private static final String QN_PROJECT_STORE_QUALIFIER = "org.zeroturnaround.eclipse.ideCommonProjectStorage";

    public EclipseIdeProject(IProject project) {
        this.project = project;
        this.ideProjectStorage = new EclipseProjectStorage();
    }

    protected EclipseIdeProject(IProject project, IdeStorage ideProjectStorage) {
        this.project = project;
        this.ideProjectStorage = ideProjectStorage;
    }

    public IdeStorage storage() {
        return this.ideProjectStorage;
    }

    public IProject getEclipseProject() {
        return this.project;
    }

    public boolean isJRebelEnabled() {
        return ProjectHelper.isJRebelProject(this.project);
    }

    public boolean isRemoteServerSupportEnabled() {
        return ProjectHelper.isJRebelRemotingProject(this.project);
    }

    public boolean isJRebelProject() {
        return ProjectHelper.isJRebelProject(this.project);
    }

    public boolean isEligibleForJRebel() {
        return ProjectHelper.isEligibleForJRebel(this.project);
    }

    public boolean isStandaloneProject() {
        return ProjectHelper.isStandaloneProject(this.project);
    }

    public void disableRemoteServerSupport() {
        try {
            if (this.isRemoteServerSupportEnabled()) {
                new RebelRemotingProvider().updateRemotingEnablement(this.project, false, null);
            } else {
                log.warn("Could not disable remote server support for {} as it was not remote project", (Object)this.project);
            }
        }
        catch (Exception e) {
            log.warn("Got exception while trying to disable remote server support for " + this.project, (Throwable)e);
        }
    }

    public String getName() {
        return this.project.getName();
    }

    class EclipseProjectStorage
    extends IdeStorage {
        EclipseProjectStorage() {
        }

        public String getString(String key) {
            try {
                return EclipseIdeProject.this.project.getPersistentProperty(new QualifiedName(EclipseIdeProject.QN_PROJECT_STORE_QUALIFIER, key));
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                return null;
            }
        }

        public void setString(String key, String value) {
            try {
                EclipseIdeProject.this.project.setPersistentProperty(new QualifiedName(EclipseIdeProject.QN_PROJECT_STORE_QUALIFIER, key), value);
            }
            catch (CoreException e) {
                log.error((Throwable)e);
            }
        }
    }
}

