/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class Hooks {
    public static final String DEFAULT_HOOK_CLASS_PROPERTY = "class";

    public static <T> T getHookOpt(Class<T> clazz, String extensionId) {
        return Hooks.getHookOpt(clazz, extensionId, DEFAULT_HOOK_CLASS_PROPERTY);
    }

    public static <T> List<T> getHookList(Class<T> clazz, String extensionId) {
        return Hooks.getHookList(clazz, extensionId, DEFAULT_HOOK_CLASS_PROPERTY);
    }

    public static <T> T getHookOpt(Class<T> clazz, String extensionId, String propertyName) {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
        if (configs == null || configs.length == 0) {
            return null;
        }
        if (configs.length > 1) {
            throw new IllegalStateException("Multiple Hooks present where one expected for class: " + clazz.getName());
        }
        try {
            Object hook = configs[0].createExecutableExtension(propertyName);
            if (!clazz.isAssignableFrom(hook.getClass())) {
                throw new IllegalStateException("Hook is not a " + clazz.getName() + " (was: " + hook.getClass().getName() + ")");
            }
            return (T)hook;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create hook for " + clazz.getName(), e);
        }
    }

    public static <T> List<T> getHookList(Class<T> clazz, String extensionId, String propertyName) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return new ArrayList();
        }
        IConfigurationElement[] configs = extensionRegistry.getConfigurationElementsFor(extensionId);
        ArrayList<Object> providers = new ArrayList<Object>(configs.length);
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement configElem = configs[i];
            try {
                Object hook = configElem.createExecutableExtension(DEFAULT_HOOK_CLASS_PROPERTY);
                if (!clazz.isInstance(hook)) {
                    throw new IllegalStateException("Hook is not a " + clazz.getName() + " (was: " + hook.getClass().getName() + ")");
                }
                providers.add(hook);
            }
            catch (CoreException e) {
                throw new IllegalStateException("Unable to create hook for " + clazz.getName(), e);
            }
            ++i;
        }
        return providers;
    }
}

