/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse;

import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zeroturnaround.eclipse.EclipseCommonStartup;
import org.zeroturnaround.eclipse.RebelLog;
import org.zeroturnaround.eclipse.debug.DebuggerIntegration;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.events.JRebelService;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceImpl;
import org.zeroturnaround.eclipse.jrebel.events.NullJRebelService;
import org.zeroturnaround.eclipse.jrebel.remoting.console.RemotingConsole;
import org.zeroturnaround.eclipse.launch.RebelArgsFixingLaunchListener;
import org.zeroturnaround.eclipse.launching.support.LaunchUtil;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.plugins.PluginProvisioningListener;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;
import org.zeroturnaround.jrebel.ide.common.http.server.IDEPluginHttpServerHolder;
import org.zeroturnaround.jrebel.ide.common.notifications.LicenseNotifier;

public class RebelPlugin
extends AbstractUIPlugin
implements EventHandler {
    private static final Log log;
    public static final String SETUP_GUIDE_INITIALIZED_EVENT_TOPIC = "org/zeroturnaround/eclipse/feature/guide/INITIALIZED";
    public static final String PLUGIN_ID = "org.zeroturnaround.eclipse";
    public static final String REMOTING_PLUGIN_ID = "org.zeroturnaround.eclipse.remoting";
    public static final String EXTENSION_POINT_WEB_CONTENT_PROVIDER = "rebelWebContentDirProvider";
    private static RebelPlugin plugin;
    private RebelArgsFixingLaunchListener launchListener = new RebelArgsFixingLaunchListener();
    private JRebelService service = new JRebelServiceImpl();
    private final AtomicBoolean licensingNotifierInitialized = new AtomicBoolean();

    static {
        RebelLog.init();
        log = Log.getInstance(RebelPlugin.class);
    }

    public synchronized void start(BundleContext context) throws Exception {
        super.start(context);
        log.info("Starting plugin with version {}", (Object)this.getBundle().getVersion());
        plugin = this;
        log.debug("Common critical start");
        new EclipseCommonStartup().criticalStart();
        this.addSetupGuideInitializationListener(context);
        this.getPreferenceStore().getInt("preference.store.version");
        this.startServicesAsync(context);
    }

    private void addSetupGuideInitializationListener(BundleContext context) {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        ht.put("event.topics", new String[]{SETUP_GUIDE_INITIALIZED_EVENT_TOPIC});
        context.registerService(EventHandler.class.getName(), (Object)this, ht);
    }

    private void startServicesAsync(final BundleContext context) {
        new Job("JRebel plugin startup"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RebelPlugin.this.startPluginServices(context);
                    log.info("Plugin startup finshed");
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    log.error("Startup error", (Throwable)e);
                    IStatus iStatus = RebelPlugin.newErrorStatus("JRebel plugin startup error", e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        }.schedule();
        new Job("LicenseNotifier initialization fallback"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (RebelPlugin.this.licensingNotifierInitialized.compareAndSet(false, true)) {
                    LicenseNotifier.init();
                }
                return Status.OK_STATUS;
            }
        }.schedule(10000L);
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent evt) {
                if (evt.getBundle() != context.getBundle()) {
                    return;
                }
                if (evt.getType() != 2) {
                    return;
                }
                context.removeBundleListener((BundleListener)this);
                RebelPlugin.this.nonCriticalStart();
            }
        });
    }

    private void nonCriticalStart() {
        new Job("JRebel plugin non critical start"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    log.info("Bundle started, running non critical startup");
                    new EclipseCommonStartup().start();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    log.error("Startup error", (Throwable)e);
                    IStatus iStatus = RebelPlugin.newErrorStatus("JRebel plugin startup error", e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        }.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPluginServices(BundleContext context) {
        Class<RebelPlugin> clazz = RebelPlugin.class;
        synchronized (RebelPlugin.class) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this.launchListener);
            launchManager.addLaunchListener((ILaunchListener)this.launchListener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                IDEPluginHttpServerHolder.getInstance().start();
            }
            catch (Exception e) {
                log.error("Failed to start IDE HTTP server", (Throwable)e);
            }
            this.addProvisioningListener(context);
            ConsoleLog.setConsole((ConsoleLog.IdeConsoleLogger)RemotingConsole.getInstance());
            DebuggerIntegration.start();
            this.addProjectReconfigurationListener();
            return;
        }
    }

    private void addProjectReconfigurationListener() {
        ((Workspace)EclipseUtil.getWorkspace()).addLifecycleListener(new ILifecycleListener(){
            private boolean eventBeingHandled = false;

            public void handleEvent(LifecycleEvent event) throws CoreException {
                if (!this.eventBeingHandled && event.kind == 2) {
                    try {
                        this.eventBeingHandled = true;
                        log.debug("Project change event - kind: {}, resource: {}", (Object)event.kind, (Object)event.resource);
                        IProject project = (IProject)event.resource;
                        JRebelProject rebelProject = ProjectHelper.getJRebelProject(project);
                        if (rebelProject != null && !rebelProject.isJRebelDisabled()) {
                            this.forceBuilderAsLastOne(project);
                        }
                    }
                    finally {
                        this.eventBeingHandled = false;
                    }
                }
            }

            private void forceBuilderAsLastOne(IProject project) throws CoreException {
                IProjectDescription description = project.getDescription();
                ICommand[] commands = description.getBuildSpec();
                int commandsCount = commands.length;
                if (commandsCount == 0 || "org.zeroturnaround.eclipse.rebelXmlBuilder".equals(commands[commandsCount - 1].getBuilderName())) {
                    return;
                }
                int i = 0;
                while (i < commandsCount) {
                    if ("org.zeroturnaround.eclipse.rebelXmlBuilder".equals(commands[i].getBuilderName())) {
                        ICommand[] newCommands = new ICommand[commandsCount];
                        newCommands[commandsCount - 1] = commands[i];
                        System.arraycopy(commands, 0, newCommands, 0, i);
                        System.arraycopy(commands, i + 1, newCommands, i, commandsCount - i - 1);
                        description.setBuildSpec(newCommands);
                        project.setDescription(description, 65, (IProgressMonitor)new NullProgressMonitor());
                        log.info("Reconfigured project {} to have RebelXmlBuilder as last", (Object)project);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    private void addProvisioningListener(BundleContext context) {
        try {
            PluginProvisioningListener listener = new PluginProvisioningListener(PLUGIN_ID){

                @Override
                protected void onUninstall() {
                    LaunchUtil.setJRebelDisabledForStandaloneLaunchConfigurations();
                }

                @Override
                protected void onUpgrade(Version oldVersion, Version newVersion) {
                    try {
                        if (JRebel.isExternalAgentSelected()) {
                            JRebel externalJRebel = JRebel.getExternal();
                            org.zeroturnaround.common.Version externalVersion = externalJRebel.getVersion();
                            org.zeroturnaround.common.Version jrebelCompatibleNewVersion = this.getTrimmedVersion(newVersion);
                            log.info("Old external agent: {}, new agent: {}", (Object)externalVersion, (Object)jrebelCompatibleNewVersion);
                            if (externalVersion.compareTo(jrebelCompatibleNewVersion) <= 0) {
                                log.debug("Selecting embedded agent");
                                this.selectGriffinAgent();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Could not run upgrade process", (Throwable)e);
                    }
                }

                private void selectGriffinAgent() {
                    EclipseUtil.runInUiThread(new Runnable(){

                        @Override
                        public void run() {
                            JRebelClientAdapter.getInstance().getClientSettings().switchJRebelClientToGriffin();
                            log.debug("selected embedded agent");
                        }
                    });
                }

                private org.zeroturnaround.common.Version getTrimmedVersion(Version version) {
                    StringBuilder sb = new StringBuilder().append(version.getSegment(0)).append(".").append(version.getSegment(1)).append(".").append(version.getSegment(2));
                    if (version.toString().contains("PREVIEW")) {
                        sb.append("-SNAPSHOT");
                    }
                    return new org.zeroturnaround.common.Version(sb.toString());
                }
            };
            listener.addToContext(context);
        }
        catch (Exception e) {
            log.debug("got exception while setting up provisioning listener. " + e.toString());
        }
    }

    public synchronized void stop(BundleContext context) throws Exception {
        log.info("Stopping plugin");
        new EclipseCommonStartup().stop();
        this.service = null;
        plugin = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (this.launchListener != null && debugPlugin != null) {
            debugPlugin.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.launchListener);
            debugPlugin.getLaunchManager().removeLaunchListener((ILaunchListener)this.launchListener);
            this.launchListener = null;
        }
        super.stop(context);
    }

    public static RebelPlugin getDefault() {
        if (plugin == null) {
            String msg = " -- ERROR: RebelPlugin.getDefault() retured null!! Likely cause: plugin not started properly!";
            System.out.println(msg);
        }
        return plugin;
    }

    public static JRebelService getJRebelService() {
        if (RebelPlugin.getDefault() == null) {
            log.warn("Plugin is null, returning null service");
            return new NullJRebelService();
        }
        return RebelPlugin.getDefault().service;
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public static CoreException createCoreException(String msg) {
        log.error(msg);
        return new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public static CoreException createCoreException(String msg, Throwable t) {
        log.error(msg, t);
        return new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public void handleEvent(Event event) {
        if (SETUP_GUIDE_INITIALIZED_EVENT_TOPIC.equals(event.getTopic()) && this.licensingNotifierInitialized.compareAndSet(false, true)) {
            LicenseNotifier.init();
        }
    }
}

