/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlGenerator;
import org.zeroturnaround.jrebel.client.xmlgen.BuildTool;

public class ExternalBuildRebelXmlGenerator {
    public static boolean canGenerateWithExternalBuildTool(IProject project) {
        for (IRebelXmlGenerator generator : Hooks.getHookList(IRebelXmlGenerator.class, "org.zeroturnaround.rebel.xml.generation.v3")) {
            if (!generator.canGenerate(project)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static IRebelXmlGenerator.GenerationResult tryToGenerateRebelXmlWithExternalBuildTool(IProject project, File destinationFolder) {
        IRebelXmlGenerator.GenerationResult failCandidate = null;
        for (IRebelXmlGenerator generator : Hooks.getHookList(IRebelXmlGenerator.class, "org.zeroturnaround.rebel.xml.generation.v3")) {
            IRebelXmlGenerator.GenerationResult generationResult = generator.generate(project, destinationFolder);
            if (generationResult.getResult() == IRebelXmlGenerator.ExternalGenerationResult.OK) {
                return generationResult;
            }
            if (generationResult.getResult() == IRebelXmlGenerator.ExternalGenerationResult.MISCONFIGURED) continue;
            failCandidate = generationResult;
        }
        if (failCandidate != null) {
            return failCandidate;
        }
        return new IRebelXmlGenerator.GenerationResult(null, IRebelXmlGenerator.ExternalGenerationResult.UNSUPPORTED);
    }

    public static List<BuildTool> unsupportedBuildToolList() {
        LinkedHashSet<BuildTool> resultSet = new LinkedHashSet<BuildTool>();
        for (IRebelXmlGenerator generator : Hooks.getHookList(IRebelXmlGenerator.class, "org.zeroturnaround.rebel.xml.generation.v3")) {
            IRebelXmlGenerator.BuildToolSupportStatus status = generator.supportStatus();
            if (status.isSupported()) continue;
            resultSet.add(status.getBuildTool());
        }
        return new ArrayList<BuildTool>(resultSet);
    }
}

