/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.ProjectHelper;

public class OpenJRebelProjectPropertiesAction
implements IObjectActionDelegate {
    private ISelection selection;
    private Shell shell;
    private final Runnable propertyDialogOnSaveAction;
    private final Runnable propertyDialogOnCancelAction;

    public OpenJRebelProjectPropertiesAction() {
        this(null, null);
    }

    public OpenJRebelProjectPropertiesAction(Runnable propertyDialogOnSaveAction, Runnable propertyDialogOnCancelAction) {
        this.propertyDialogOnSaveAction = propertyDialogOnSaveAction;
        this.propertyDialogOnCancelAction = propertyDialogOnCancelAction;
    }

    public void run(IAction action) {
        IProject project = this.getProject();
        if (project != null) {
            this.updateAction(action);
            int ret = PreferencesUtil.createPropertyDialogOn((Shell)this.shell, (IAdaptable)project, (String)"org.zeroturnaround.eclipse.properties.jrebelPropertiesPage", null, null).open();
            if (ret == 0 && this.propertyDialogOnSaveAction != null) {
                this.propertyDialogOnSaveAction.run();
            }
            if (ret == 1 && this.propertyDialogOnCancelAction != null) {
                this.propertyDialogOnCancelAction.run();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.updateAction(action);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null && targetPart.getSite() != null) {
            this.shell = targetPart.getSite().getShell();
        }
        this.updateAction(action);
    }

    private void updateAction(IAction action) {
        if (this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).size() > 1) {
            action.setEnabled(false);
            return;
        }
        IProject project = this.getProject();
        if (project != null && ProjectHelper.isJRebelProject(project)) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public IProject getProject() {
        return RebelXmlGenerator.getProjectFromSelection(this.selection);
    }
}

