/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.actions;

import com.zeroturnaround.javarebel.conf.RebelConf;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.common.util.IdeStringUtils;
import org.zeroturnaround.common.xml.XmlUtil;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.IRebelWebContentDirProvider;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlLocator;
import org.zeroturnaround.eclipse.actions.extension.RebelClasspathEntry;
import org.zeroturnaround.eclipse.actions.extension.RebelWebEntry;
import org.zeroturnaround.eclipse.actions.extension.RebelXmlContributionProcessor;
import org.zeroturnaround.eclipse.nature.MyResourceVisitor;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.RemoteModuleName;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.constants.JavaConstants;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.xmlgen.CommonRebelXmlUtils;
import org.zeroturnaround.jrebel.client.xmlgen.RebelXml;
import org.zeroturnaround.jrebel.ide.common.utils.RebelConfBackupUtil;

public class RebelXmlGenerator {
    private static final String REBEL_XML_GENERATION_INVARIANT_TOKEN = "rebel.xml.generation.invariant.token";
    private static final Log log = Log.getInstance(RebelXmlGenerator.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(RebelXmlGenerator.class);
    private static final boolean AUTOGENERATE_REBEL_XML = RebelConf.getBooleanOrDefault((String)"rebel.ide.autogenerate_rebel_xml", (boolean)true);
    public static final String MVN_SRC_MAIN_RESOURCES = "src/main/resources";
    private static final String EAR_MVN_SOURCE = "src/main/application/APP-INF/classes";
    private static final String EAR_ECLIPSE_SOURCE = "EarContent/APP-INF/classes";
    private static final String MVN_TEST_CLASSES = "target/test-classes";
    private static final QualifiedName REBEL_XML_TIMESTAMP = new QualifiedName("org.zeroturnaround.eclipse.actions.RebelXmlGenerator", "rebelXmlTimestamp");
    public static final QualifiedName DEPLOYMENT_PATH_QUALIFIER = new QualifiedName("org.zeroturnaround.eclipse", "deploymentPath");
    private final IJavaProject javaProject;
    private final IProject project;

    private RebelXmlGenerator(@NotNull IProject project, @Nullable IJavaProject javaProject) {
        this.project = project;
        this.javaProject = javaProject;
    }

    @NotNull
    public static List<IProject> getProjectsFromSelection(ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        ArrayList<IProject> list = new ArrayList<IProject>();
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (Object element : ss.toList()) {
            if (element instanceof IProject) {
                list.add((IProject)element);
                continue;
            }
            if (element instanceof IAdaptable) {
                Object project = ((IAdaptable)element).getAdapter(IProject.class);
                list.add((IProject)project);
                continue;
            }
            log.warn("Unable to map selection to project: {}, '{}'", element.getClass(), element);
        }
        return list;
    }

    @Nullable
    public static IProject getProjectFromSelection(ISelection selection) {
        List<IProject> project = RebelXmlGenerator.getProjectsFromSelection(selection);
        return !project.isEmpty() ? project.get(0) : null;
    }

    @Nullable
    public static RebelXmlGenerator forProject(@Nullable IProject project) {
        if (project != null && project.isOpen()) {
            IJavaProject javaProject = EclipseUtil.getJavaProject(project);
            return new RebelXmlGenerator(project, javaProject);
        }
        return null;
    }

    private static boolean pathExists(IProject project, IPath path) {
        IPath projectPath;
        block3: {
            try {
                projectPath = project.getLocation().append(path);
                if (projectPath != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return projectPath.toFile().exists();
    }

    @NotNull
    public IContainer findBestSourceFolderForRebelXml() throws CoreException {
        log.debug("findBestSourceFolderForRebelXml, {}", (Object)this.project);
        if (this.javaProject == null) {
            return this.findNonJavaResourceLocation(this.project);
        }
        IContainer foundResource = RebelXmlGenerator.findInProjectSourceRoots(this.javaProject);
        return foundResource != null ? foundResource : this.javaProject.getProject();
    }

    private static IContainer findResourceLocationViaLocators(IProject project) throws CoreException {
        List<IRebelXmlLocator> hookList = Hooks.getHookList(IRebelXmlLocator.class, "org.zeroturnaround.rebel.xml.location.v3");
        for (IRebelXmlLocator locator : hookList) {
            log.debug("Found RebelXmlLocator {}", (Object)locator);
            IPath resource = locator.getRebelXmlLocation(new EclipseIdeProject(project));
            if (resource == null) continue;
            return RebelXmlGenerator.resolveFolderAndCreate(project, resource);
        }
        return null;
    }

    private IContainer findNonJavaResourceLocation(IProject project) throws CoreException {
        try {
            IPath path;
            IContainer locatorLocation = RebelXmlGenerator.findResourceLocationViaLocators(project);
            if (locatorLocation != null) {
                return locatorLocation;
            }
            String portablePath = project.getPersistentProperty(DEPLOYMENT_PATH_QUALIFIER);
            if (portablePath != null) {
                path = Path.fromPortableString((String)portablePath);
                log.info("session contains deployment path " + path);
                path = path.append("APP-INF/classes");
                if (RebelXmlGenerator.pathExists(project, path)) {
                    log.info("found DEPLOYMENT_PATH");
                    return project.getFolder(path);
                }
                log.info("path doesn't exist " + path);
            }
            if (RebelXmlGenerator.pathExists(project, path = new Path(EAR_MVN_SOURCE))) {
                log.info("found EAR_MVN_SOURCE");
                return project.getWorkspace().getRoot().getFolder(path);
            }
            path = new Path(EAR_ECLIPSE_SOURCE);
            if (RebelXmlGenerator.pathExists(project, path)) {
                log.info("found EAR_ECLIPSE_SOURCE");
                return project.getWorkspace().getRoot().getFolder(path);
            }
            MyResourceVisitor visitor = new MyResourceVisitor(null, "APP-INF/classes", ProjectHelper.DEFAULT_OUT_FOLDERS);
            project.accept((IResourceVisitor)visitor);
            if (visitor.getFoundFolder() != null) {
                return visitor.getFoundFolder();
            }
            visitor = new MyResourceVisitor(null, "classes", ProjectHelper.DEFAULT_OUT_FOLDERS);
            project.accept((IResourceVisitor)visitor);
            if (visitor.getFoundFolder() != null) {
                return visitor.getFoundFolder();
            }
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
        }
        return project.getProject();
    }

    @Nullable
    private static IContainer findInProjectSourceRoots(@NotNull IJavaProject javaProject) throws CoreException {
        IContainer foundResource = RebelXmlGenerator.findExistingXmlFolder(javaProject);
        if (foundResource == null) {
            foundResource = RebelXmlGenerator.findDefaultResourceDirectory(javaProject);
        }
        if (foundResource == null) {
            foundResource = RebelXmlGenerator.findResourceLocationViaLocators(javaProject.getProject());
        }
        if (foundResource == null) {
            foundResource = RebelXmlGenerator.getAphabeticallyFirstSourceFolder(javaProject);
        }
        return foundResource;
    }

    private static IContainer findExistingXmlFolder(IJavaProject javaProject) throws JavaModelException {
        ContainerPredicate<IContainer> filter = it -> it.findMember("rebel.xml") instanceof IFile;
        return RebelXmlGenerator.findInResourceLocations(javaProject, filter);
    }

    private static IContainer findDefaultResourceDirectory(IJavaProject javaProject) throws JavaModelException {
        ContainerPredicate<IContainer> filter = it -> new Path(MVN_SRC_MAIN_RESOURCES).equals((Object)it.getProjectRelativePath());
        return RebelXmlGenerator.findInResourceLocations(javaProject, filter);
    }

    @Nullable
    private static IContainer findInResourceLocations(IJavaProject javaProject, ContainerPredicate<IContainer> filter) throws JavaModelException {
        for (IContainer container : RebelXmlGenerator.getAllSourceDirectories(javaProject)) {
            if (!filter.matches(container)) continue;
            return container;
        }
        return null;
    }

    private static List<IContainer> getAllSourceDirectories(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IContainer> sources = new ArrayList<IContainer>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IPackageFragmentRoot pkgRoot = iPackageFragmentRootArray[n2];
            if (pkgRoot.exists() && pkgRoot.getKind() == 1 && (resource = pkgRoot.getResource()).exists() && resource instanceof IContainer) {
                sources.add((IContainer)resource);
            }
            ++n2;
        }
        return sources;
    }

    private static IContainer getAphabeticallyFirstSourceFolder(IJavaProject javaProject) throws JavaModelException {
        List<IContainer> sources = RebelXmlGenerator.getAllSourceDirectories(javaProject);
        if (!sources.isEmpty()) {
            Collections.sort(sources, new Comparator<IContainer>(){

                @Override
                public int compare(IContainer o1, IContainer o2) {
                    return o1.getProjectRelativePath().toString().compareTo(o2.getProjectRelativePath().toString());
                }
            });
            return sources.get(0);
        }
        return null;
    }

    @NotNull
    static IFolder resolveFolderAndCreate(IProject project, IPath path) throws CoreException {
        IFolder folder = project.getFolder(path);
        if (!folder.exists()) {
            File file = folder.getLocation().toFile().getAbsoluteFile();
            log.debug("Creating resource directory: {}", (Object)file);
            if (!file.mkdirs() && file.exists()) {
                log.warn("Necessary folder at {} might not have been created", (Object)path);
            }
            folder.refreshLocal(0, null);
            try {
                RebelXmlGenerator.addToClasspath(project, folder);
            }
            catch (Exception e) {
                log.error("Could not add {} to classpath", (Object)folder, (Object)e);
            }
        }
        return folder;
    }

    private static void addToClasspath(IProject project, IFolder folder) throws CoreException {
        IJavaProject javaProject = EclipseUtil.getJavaProject(project);
        if (javaProject == null) {
            return;
        }
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
        IPath newFolderPath = folder.getFullPath();
        for (IClasspathEntry entry : classpath) {
            newClasspath.add(RebelXmlGenerator.getEntryWithExclusion(entry, newFolderPath));
        }
        newClasspath.add(JavaCore.newSourceEntry((IPath)newFolderPath));
        javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), null);
    }

    private static IClasspathEntry getEntryWithExclusion(IClasspathEntry entry, IPath newFolderPath) {
        Object[] exclusionPatterns;
        IPath sourcePath = entry.getPath();
        if (!sourcePath.isPrefixOf(newFolderPath)) {
            return entry;
        }
        IPath exclusion = newFolderPath.makeRelativeTo(sourcePath);
        if (!exclusion.hasTrailingSeparator()) {
            exclusion = exclusion.addTrailingSeparator();
        }
        if (!ArrayUtils.contains((Object[])(exclusionPatterns = entry.getExclusionPatterns()), (Object)exclusion)) {
            IPath[] newExclusionPatterns = (IPath[])ArrayUtils.add((Object[])exclusionPatterns, (Object)exclusion);
            log.warn("Updating existing source entry {} by adding exclusion to support adding new classpath entry {}", new Object[]{sourcePath, exclusion, newFolderPath});
            return JavaCore.newSourceEntry((IPath)sourcePath, (IPath[])entry.getInclusionPatterns(), (IPath[])newExclusionPatterns, (IPath)entry.getOutputLocation(), (IClasspathAttribute[])entry.getExtraAttributes());
        }
        return entry;
    }

    public void generate(Input genInput, boolean checkFileTimestamp, String reasonInfo) {
        try {
            this.generateIn(genInput, checkFileTimestamp, reasonInfo);
        }
        catch (Exception e) {
            consoleLog.error("Generating rebel.xml to {} failed ({}).", (Object)genInput.container.getFullPath(), (Object)e.getMessage());
            ConsoleLog.open();
        }
    }

    public void generateIn(Input genInput, boolean checkFileTimestamp, String reasonInfo) throws CoreException {
        IRebelWebContentDirProvider[] providers;
        int n;
        log.trace("generateIn checkFileTimestamp=" + checkFileTimestamp);
        IContainer location = genInput.container;
        IWorkspaceRoot root = this.project.getWorkspace().getRoot();
        LinkedHashSet<String> classpathDirs = new LinkedHashSet<String>();
        if (this.isGrailsProject(this.project)) {
            List<String> classpath = this.getGrailsTargetPath(this.project);
            String webDir = this.project.getLocation().append("web-app").toPortableString();
            this.writeToFile(location, this.getRebelXml(classpath, webDir, genInput), checkFileTimestamp, reasonInfo);
            return;
        }
        if (this.javaProject == null) {
            log.info("generateIn() for non-java");
            IFolder outputFolder = null;
            MyResourceVisitor visitor = new MyResourceVisitor(null, "APP-INF/classes", ProjectHelper.DEFAULT_OUT_FOLDERS);
            this.project.accept((IResourceVisitor)visitor);
            if (visitor.getFoundFolder() != null) {
                outputFolder = visitor.getFoundFolder();
            }
            if (outputFolder == null) {
                visitor = new MyResourceVisitor(null, "classes", ProjectHelper.DEFAULT_OUT_FOLDERS);
                this.project.accept((IResourceVisitor)visitor);
                if (visitor.getFoundFolder() != null) {
                    outputFolder = visitor.getFoundFolder();
                }
            }
            if (outputFolder != null) {
                classpathDirs.add(this.getPortablePath(outputFolder.getLocation(), genInput.useRelativePaths));
            }
            String rebelXmlContent = this.getRebelXml(classpathDirs, null, genInput);
            this.writeToFile(location, rebelXmlContent, checkFileTimestamp, reasonInfo);
            return;
        }
        if (checkFileTimestamp && this.restoreRebelXml(location)) {
            log.info("Using existing backed up rebel.xml");
            location.refreshLocal(1, null);
            return;
        }
        if (!RebelXmlContributionProcessor.isDefaultClasspathEntriesHandledByContributor(this.project)) {
            IClasspathEntry[] classpath;
            IPath output = this.javaProject.getOutputLocation().equals((Object)this.project.getFullPath()) ? this.project.getLocation() : root.getFolder(this.javaProject.getOutputLocation()).getLocation();
            IClasspathEntry[] iClasspathEntryArray = classpath = this.javaProject.getResolvedClasspath(true);
            n = classpath.length;
            int rebelXmlContent = 0;
            while (rebelXmlContent < n) {
                IClasspathEntry cp = iClasspathEntryArray[rebelXmlContent];
                if (cp.getEntryKind() == 3) {
                    if (cp.getOutputLocation() != null) {
                        if (!cp.getOutputLocation().equals((Object)this.project.getFolder(MVN_TEST_CLASSES).getFullPath())) {
                            classpathDirs.add(this.getPortablePath(root.getFolder(cp.getOutputLocation()).getLocation(), genInput.useRelativePaths));
                        }
                    } else {
                        classpathDirs.add(this.getPortablePath(output, genInput.useRelativePaths));
                    }
                }
                ++rebelXmlContent;
            }
            classpathDirs.add(this.getPortablePath(output, genInput.useRelativePaths));
        }
        IPath webContentLoc = null;
        IRebelWebContentDirProvider[] iRebelWebContentDirProviderArray = providers = this.getWebContentDirProviders();
        int n2 = providers.length;
        n = 0;
        while (n < n2) {
            IRebelWebContentDirProvider provider = iRebelWebContentDirProviderArray[n];
            IPath loc = provider.getWebContentDir(this.project);
            if (loc != null) {
                webContentLoc = loc;
                break;
            }
            ++n;
        }
        String webContentDir = webContentLoc == null ? null : this.getPortablePath(webContentLoc, genInput.useRelativePaths);
        this.writeToFile(location, this.getRebelXml(classpathDirs, webContentDir, genInput), checkFileTimestamp, reasonInfo);
    }

    private boolean restoreRebelXml(@NotNull IContainer targetFolder) {
        File root = this.toFile((IResource)this.project);
        File targetFile = this.toFile((IResource)targetFolder);
        if (root == null || targetFile == null) {
            log.warn("Unable to restore rebel-remote.xml, missing root: {} ({}) or target: {} ({})", new Object[]{this.project, root, targetFolder, targetFile});
            return false;
        }
        IFile rebelXml = targetFolder.getFile((IPath)new Path("rebel.xml"));
        if (rebelXml.isLinked()) {
            try {
                rebelXml.delete(true, false, null);
            }
            catch (CoreException coreException) {
                log.error("Failed to delete linked resource");
            }
        }
        IEclipsePreferences prefsNode = new ProjectScope(this.project).getNode("org.zeroturnaround.eclipse");
        String ideGenToken = prefsNode.get(REBEL_XML_GENERATION_INVARIANT_TOKEN, null);
        return RebelConfBackupUtil.restoreFromProject((File)root, (File)targetFile, (RebelConfBackupUtil.Xml)RebelConfBackupUtil.Xml.REBEL_XML, (RebelConfBackupUtil.Product)RebelConfBackupUtil.Product.ECLIPSE, (String)ideGenToken);
    }

    @Nullable
    private File toFile(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getLocation();
        if (path == null) {
            return null;
        }
        return path.toFile();
    }

    private boolean isGrailsProject(@Nullable IProject project) {
        return ProjectHelper.hasNature(project, "org.grails.ide.eclipse.core.nature");
    }

    @NotNull
    private List<String> getGrailsTargetPath(@NotNull IProject project) {
        try {
            String path;
            File buildConfig = new File(project.getLocation().append("grails-app/conf/BuildConfig.groovy").toPortableString());
            if (buildConfig.exists() && !StringUtils.isEmpty((CharSequence)(path = IdeStringUtils.unquoteString((String)IdeStringUtils.extractSingleStringGroovyParameterValue((File)buildConfig, (String)"grails.project.class.dir"))))) {
                Collections.singleton(project.getLocation().append(path.trim()).toPortableString());
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return new ArrayList<String>();
    }

    private void writeToFile(@NotNull IContainer location, String content, boolean checkFileTimestamp, String reasonInfo) throws CoreException {
        IFile rebelFile = this.project.getFile(location.getProjectRelativePath().append("rebel.xml"));
        if (!rebelFile.getParent().exists()) {
            rebelFile = this.project.getFile(location.getFullPath().append("rebel.xml"));
        }
        if (rebelFile.isLinked()) {
            rebelFile = this.project.getWorkspace().getRoot().getFile(rebelFile.getFullPath());
            rebelFile.delete(true, false, null);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(JavaConstants.UTF_8));
        this.logFileTimestamp(rebelFile);
        if (this.overwriteFile(rebelFile, checkFileTimestamp)) {
            log.trace("writing rebel.xml content to file");
            if (rebelFile.exists()) {
                if (this.contentsEqual(content, rebelFile)) {
                    log.trace("Skipping updating rebel.xml as content would be the same");
                } else {
                    rebelFile.setContents((InputStream)input, 1, null);
                }
            } else {
                rebelFile.create((InputStream)input, true, null);
            }
            this.saveGenerationInvariantToken(content);
            this.project.setPersistentProperty(REBEL_XML_TIMESTAMP, Long.toString(this.getFileTimestamp(rebelFile)));
            log.info("Generated {} in {}. Trigger: {}", new Object[]{"rebel.xml", location.getFullPath(), reasonInfo});
        }
    }

    private void saveGenerationInvariantToken(String content) {
        try {
            IEclipsePreferences prefsNode = new ProjectScope(this.project).getNode("org.zeroturnaround.eclipse");
            String token = XmlUtil.convertXMLToTextToken((String)content);
            prefsNode.put(REBEL_XML_GENERATION_INVARIANT_TOKEN, token);
            prefsNode.flush();
            log.trace("Saved rebel.xml IDE generation invariant token: {}", (Object)token);
        }
        catch (Exception ex) {
            log.warn("Failed to create rebel.xml generation invariant token", (Throwable)ex);
        }
    }

    private boolean contentsEqual(String content, @NotNull IFile rebelFile) {
        try {
            String oldContents = FileUtils.readFileToString((File)rebelFile.getLocation().toFile());
            boolean rebelXmlContentsEqual = content.equals(oldContents);
            log.debug("Is same rebel.xml content: {}", (Object)rebelXmlContentsEqual);
            return rebelXmlContentsEqual;
        }
        catch (IOException e) {
            log.warn("Failed to look up old rebel.xml content", (Throwable)e);
            return false;
        }
    }

    private boolean overwriteFile(IFile rebelFile, boolean checkFileTimestamp) {
        if (!checkFileTimestamp) {
            return true;
        }
        if (rebelFile.exists()) {
            try {
                long fileTimestamp = this.getFileTimestamp(rebelFile);
                String generationTimestamp = this.project.getPersistentProperty(REBEL_XML_TIMESTAMP);
                log.trace("file timestamp: " + fileTimestamp);
                log.trace("our timestamp: " + generationTimestamp);
                return generationTimestamp != null && fileTimestamp == Long.parseLong(generationTimestamp);
            }
            catch (CoreException e) {
                log.error("Failed to read rebel.xml generation timestamp", (Throwable)e);
            }
            catch (NumberFormatException nfe) {
                log.error("Failed to parse rebel.xml generation timestamp", (Throwable)nfe);
            }
        }
        return AUTOGENERATE_REBEL_XML;
    }

    private long getFileTimestamp(@NotNull IFile rebelFile) {
        IPath location = rebelFile.getLocation();
        if (location == null) {
            throw new IllegalArgumentException("file location is null");
        }
        return location.toFile().lastModified();
    }

    private void logFileTimestamp(@NotNull IFile file) {
        log.trace("logFileTimestamp. exists=" + file.exists());
        log.trace("getLocalTimeStamp " + file.getLocalTimeStamp());
        log.trace("getModificationStamp " + file.getModificationStamp());
        log.trace("getLocation " + file.getLocation());
        try {
            File f = file.getLocation().toFile();
            log.trace("f lastModified " + f.lastModified());
        }
        catch (Exception exception) {}
    }

    @Nullable
    String getPortablePath(@Nullable IPath loc, boolean useRelativePaths) {
        if (loc == null) {
            return null;
        }
        if (!useRelativePaths) {
            return loc.toString();
        }
        IPath projectPath = this.project.getLocation();
        return CommonRebelXmlUtils.getPortablePath((String)loc.toString(), (java.nio.file.Path)Paths.get(projectPath.toString(), new String[0]), (java.nio.file.Path)Paths.get(projectPath.toString(), new String[0]), (String)this.project.getName());
    }

    private String getRebelXml(Collection<String> classesDirs, String webContentDir, Input genInput) {
        RemoteModuleName.getRemoteId(this.project);
        RebelXml rebelXml = new RebelXml(RebelXml.Product.ECLIPSE);
        for (String classesDir : classesDirs) {
            rebelXml.addToClassPath(new RebelXml.Dir(classesDir));
        }
        List<RebelClasspathEntry> classpathEntries = RebelXmlContributionProcessor.processClasspathEntries(this.project);
        for (RebelClasspathEntry cpEntry : classpathEntries) {
            String path = this.getPortablePath(cpEntry.getPath(), genInput.useRelativePaths);
            if (path == null) continue;
            rebelXml.addToClassPath(new RebelXml.Dir(path, cpEntry.getIncludes(), cpEntry.getExcludes()));
        }
        List<RebelWebEntry> contributedWebEntries = RebelXmlContributionProcessor.processWebEntries(this.project);
        if (webContentDir != null || !contributedWebEntries.isEmpty()) {
            for (RebelWebEntry webEntry : contributedWebEntries) {
                String path = this.getPortablePath(webEntry.getPath(), genInput.useRelativePaths);
                if (path == null) continue;
                rebelXml.addToWeb(webEntry.getContextPath(), new RebelXml.Dir(path, webEntry.getIncludes(), webEntry.getExcludes()));
            }
        }
        return rebelXml.build();
    }

    @NotNull
    private IRebelWebContentDirProvider[] getWebContentDirProviders() {
        List<IRebelWebContentDirProvider> providers = Hooks.getHookList(IRebelWebContentDirProvider.class, "org.zeroturnaround.eclipse.rebelWebContentDirProvider");
        return providers.toArray(new IRebelWebContentDirProvider[0]);
    }

    private static interface ContainerPredicate<T> {
        public boolean matches(@NotNull T var1);
    }

    public static final class Input {
        final IContainer container;
        final boolean useRelativePaths;

        public Input(@NotNull IContainer container, boolean useRelativePaths) {
            this.container = container;
            this.useRelativePaths = useRelativePaths;
        }
    }
}

