/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.actions.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlContributor;
import org.zeroturnaround.eclipse.actions.extension.RebelClasspathEntry;
import org.zeroturnaround.eclipse.actions.extension.RebelWebEntry;

public class RebelXmlContributionProcessor {
    private static final String EXTENSION_ID = "org.zeroturnaround.rebel.xml.extension";

    public static List<IRebelXmlContributor> getRebelXmlContributors() {
        return Hooks.getHookList(IRebelXmlContributor.class, EXTENSION_ID);
    }

    public static boolean isDefaultClasspathEntriesHandledByContributor(IProject project) {
        for (IRebelXmlContributor contributor : RebelXmlContributionProcessor.getRebelXmlContributors()) {
            if (!contributor.isHandlingDefaultClassPathEntries(project)) continue;
            return true;
        }
        return false;
    }

    public static List<RebelClasspathEntry> processClasspathEntries(IProject project) {
        ArrayList<RebelClasspathEntry> cpEntries = new ArrayList<RebelClasspathEntry>();
        List<IRebelXmlContributor> rebelXmlContributors = RebelXmlContributionProcessor.getRebelXmlContributors();
        for (IRebelXmlContributor contributor : rebelXmlContributors) {
            cpEntries.addAll(contributor.getClasspathEntries(project));
        }
        return cpEntries;
    }

    public static List<RebelWebEntry> processWebEntries(IProject project) {
        ArrayList<RebelWebEntry> webEntries = new ArrayList<RebelWebEntry>();
        List<IRebelXmlContributor> rebelXmlContributors = RebelXmlContributionProcessor.getRebelXmlContributors();
        for (IRebelXmlContributor contributor : rebelXmlContributors) {
            webEntries.addAll(contributor.getWebPathEntries(project));
        }
        return webEntries;
    }
}

