/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.api;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.zeroturnaround.eclipse.launching.launchconfig.BoundRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.LaunchConfigLaunchables;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfigProviders;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class JRebelIntegration {
    private static Log log = Log.getInstance(JRebelIntegration.class);

    public static synchronized void addServer(URI uri, String serverName) {
        if (uri == null) {
            throw new IllegalArgumentException("Server uri can not be null");
        }
        log.debug("Trying to add new remote server with name {} and URI {}", (Object)serverName, (Object)uri);
        if (JRebelIntegration.getAllServers().contains(uri)) {
            log.error("Already have remote server with URI {}, not adding duplicate", (Object)uri);
            return;
        }
        RemoteServerConfiguration server = new RemoteServerConfiguration();
        server.setSyncEnabled(true);
        server.setUrl(uri);
        server.setName(serverName);
        IdeRemoting.getInstance().getConfigurations().added(server);
        log.debug("Successfully added new server");
    }

    public static synchronized void removeServer(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Server uri can not be null");
        }
        RemoteServerConfigurations instance = IdeRemoting.getInstance().getConfigurations();
        ArrayList currentServers = new ArrayList(instance.getInstanceServers());
        Iterator it = currentServers.iterator();
        int removedServerCount = 0;
        while (it.hasNext()) {
            RemoteServerConfiguration conf = (RemoteServerConfiguration)it.next();
            if (!conf.getUrl().equals(uri)) continue;
            it.remove();
            ++removedServerCount;
        }
        if (removedServerCount > 0) {
            instance.replaceInstanceServers(currentServers);
        }
        log.debug("Removed {} servers with URI {}", (Object)removedServerCount, (Object)uri);
    }

    public static synchronized List<URI> getAllServers() {
        HashSet<URI> uniqueUris = new HashSet<URI>();
        for (RemoteServerConfiguration conf : IdeRemoting.getInstance().getConfigurations().getInstanceServers()) {
            if (conf.getUrl() == null) continue;
            uniqueUris.add(conf.getUrl());
        }
        return new ArrayList<URI>(uniqueUris);
    }

    public static List<BoundRebelLaunchConfig> getBoundRebelLaunchConfigurations() throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ArrayList<BoundRebelLaunchConfig> rebelLaunchConfigs = new ArrayList<BoundRebelLaunchConfig>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            BoundRebelLaunchConfig boundRebelLaunchConfig = JRebelIntegration.tryToCreateBoundRebelLaunchConfig(launchConfig);
            if (boundRebelLaunchConfig != null) {
                rebelLaunchConfigs.add(boundRebelLaunchConfig);
            }
            ++n2;
        }
        return rebelLaunchConfigs;
    }

    public static BoundRebelLaunchConfig tryToCreateBoundRebelLaunchConfig(ILaunchConfiguration launchConfig) {
        Map cookies;
        try {
            cookies = launchConfig.getAttributes();
        }
        catch (CoreException coreException) {
            cookies = null;
        }
        IRebelLaunchConfig adaptor = RebelLaunchConfigProviders.createRebelLaunchConfig(launchConfig, cookies);
        if (adaptor == null) {
            log.warn("Failed to create RebelLaunchConfig for launch configuration {}", (Object)launchConfig);
            return null;
        }
        return LaunchConfigLaunchables.bind(launchConfig, adaptor);
    }
}

