/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.common.options;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.zeroturnaround.common.Function1;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.config.components.FileSelectionComponent;
import org.zeroturnaround.eclipse.util.EclipseUtil;

public class OptionBinding {
    public static void bind(BindingContext context, final Button button, final IOption<Boolean> option) {
        button.setSelection(((Boolean)option.getValue()).booleanValue());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = ((Button)e.widget).getSelection();
                option.setValue((Object)value);
            }
        });
        OptionBinding.bindListener(context, option, new IValueChangedListener<Boolean>(){

            public void valueChanged(IOption<Boolean> valueChangedOption) {
                button.setSelection(((Boolean)valueChangedOption.getValue()).booleanValue());
            }
        });
    }

    public static <T> void bindView(BindingContext context, final Label label, IOption<T> option, final Function1<T, String> viewFunc) {
        label.setText((String)viewFunc.apply(option.getValue()));
        OptionBinding.bindListener(context, option, new IValueChangedListener<T>(){

            public void valueChanged(IOption<T> option) {
                String viewValue = (String)viewFunc.apply(option.getValue());
                label.setText(viewValue);
            }
        });
    }

    public static void bind(BindingContext context, FileSelectionComponent fileCustom, final IOption<File> option) {
        final Text text = fileCustom.getLocationText();
        if (option.getValue() == null) {
            text.setText("");
        } else {
            text.setText(((File)option.getValue()).getAbsolutePath());
        }
        text.notifyListeners(24, null);
        final AtomicBoolean updating = new AtomicBoolean(false);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = text.getText();
                try {
                    updating.set(true);
                    if (value.length() > 0) {
                        option.setValue((Object)new File(value));
                    } else {
                        option.setValue(null);
                    }
                }
                finally {
                    updating.set(false);
                }
            }
        });
        OptionBinding.bindListener(context, option, new IValueChangedListener<File>(){

            public void valueChanged(IOption<File> option) {
                File value = (File)option.getValue();
                if (value == null) {
                    text.setText("");
                } else if (!updating.get()) {
                    text.setText(value.getAbsolutePath());
                }
            }
        });
    }

    public static void bind(BindingContext context, final Scale scale, final IOption<Integer> option) {
        scale.setSelection(((Integer)option.getValue()).intValue());
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = scale.getSelection();
                option.setValue((Object)value);
            }
        });
        OptionBinding.bindListener(context, option, option1 -> scale.setSelection(((Integer)option1.getValue()).intValue()));
    }

    public static void bind(BindingContext context, final Spinner spinner, final IOption<Integer> option) {
        int value = OptionBinding.clampValue(spinner, option);
        option.setValue((Object)value);
        spinner.setSelection(value);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = spinner.getSelection();
                option.setValue((Object)value);
            }
        });
        OptionBinding.bindListener(context, option, new IValueChangedListener<Integer>(){

            public void valueChanged(IOption<Integer> option) {
                int value = OptionBinding.clampValue(spinner, (IOption<Integer>)option);
                option.setValue((Object)value);
                spinner.setSelection(value);
            }
        });
    }

    private static int clampValue(Spinner spinner, IOption<Integer> option) {
        Integer value = (Integer)option.getValue();
        if (value == null) {
            value = spinner.getSelection();
        } else if (value > spinner.getMaximum()) {
            value = spinner.getMaximum();
        } else if (value < spinner.getMinimum()) {
            value = spinner.getMinimum();
        }
        return value;
    }

    public static <T> void bindListener(BindingContext context, IOption<T> option, IValueChangedListener<T> listener) {
        IValueChangedListener uiListener = o -> EclipseUtil.runInUiThread(() -> listener.valueChanged(o));
        option.addValueChangedListener(uiListener);
        context.add(new BindingContext.OptionValueListenerBinding<T>(option, uiListener));
    }
}

