/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.common.options;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.services.IDisposable;
import org.zeroturnaround.common.ListenerList;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class PreferenceOption<T>
implements IOption<T>,
IPropertyChangeListener,
IDisposable {
    private static final Log log = Log.getInstance(PreferenceOption.class);
    protected final IPreferenceStore prefStore;
    protected final String name;
    private final ListenerList<IValueChangedListener<T>> listeners = new ListenerList();

    public PreferenceOption(IPreferenceStore prefStore, String name) {
        this.prefStore = prefStore;
        this.name = name;
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public T getValueOrDefault() {
        Object value = this.getValue();
        return (T)(value != null ? value : this.getDefaultValue());
    }

    public boolean isDefault() {
        Object value = this.getValue();
        Object defaultValue = this.getDefaultValue();
        return value == null && defaultValue == null || value != null && value.equals(defaultValue);
    }

    public void addValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IValueChangedListener listener : this.listeners.getListeners()) {
            try {
                listener.valueChanged((IOption)this);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.name.equals(event.getProperty())) {
            this.notifyListeners();
        }
    }

    public void dispose() {
        this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public String getName() {
        return this.name;
    }
}

