/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.zeroturnaround.common.util.HtmlUtils;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.model.ProjectModel;
import org.zeroturnaround.eclipse.servers.ServerConfigProviders;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.Area;
import org.zeroturnaround.jrebel.ide.common.notifications.Level;
import org.zeroturnaround.jrebel.ide.common.notifications.MessageProducer;
import org.zeroturnaround.jrebel.ide.common.notifications.NotificationPermissions;
import org.zeroturnaround.jrebel.ide.common.notifications.NotificationType;
import org.zeroturnaround.jrebel.ide.common.notifications.Repeat;
import org.zeroturnaround.jrebel.ide.common.notifications.UserNotifications;
import org.zeroturnaround.jrebel.ide.common.notifications.producers.HtmlMessageProducer;

public class ConfigPluginStartup {
    private static final Log log = Log.getInstance(ConfigPluginStartup.class);

    public static void earlyStartup() {
        new ConfigPluginStartup().startup();
    }

    private void startup() {
        this.fixEclipsePerspectives();
        this.checkAndShowConfigureNotification();
    }

    private void checkAndShowConfigureNotification() {
        this.moveConfigureProjectNotificationToPreferences();
        if (this.shouldNotShowConfigureJRebelNotification()) {
            return;
        }
        UserNotifications.getInstance().startNotification(Repeat.ONCE, Area.IDE, Level.INFO).immediate().setType(NotificationType.CONFIGURE_JREBEL).setCondition((source, notification) -> !JRebelConfigCenter.isOpen()).setMessage((MessageProducer)this.createConfigureJRebelNotification()).send();
    }

    private HtmlMessageProducer createConfigureJRebelNotification() {
        StringBuilder body = new StringBuilder().append("You haven't configured any projects or servers yet. Open the JRebel Configuration to do so.").append("<br /><br />").append(HtmlUtils.link((String)"openProjectListPage", (String)"Open JRebel Configuration")).append(HtmlUtils.whiteSpace((int)8)).append(HtmlUtils.link((String)NotificationType.CONFIGURE_JREBEL.command, (String)"Don't show this again"));
        return new HtmlMessageProducer("Configure JRebel", body.toString());
    }

    private void moveConfigureProjectNotificationToPreferences() {
        String key = "jrebelNoProjectsOrServersCheck";
        IPreferenceStore store = RebelPlugin.getDefault().getPreferenceStore();
        if (!store.contains(key)) {
            return;
        }
        boolean value = store.getBoolean(key);
        if (!value) {
            store.setToDefault(key);
            NotificationPermissions.blockNotificationByCommand((String)NotificationType.CONFIGURE_JREBEL.command);
        }
    }

    private boolean shouldNotShowConfigureJRebelNotification() {
        LicensingStatus licensingStatus = Watcher.getInstance().getLastLicensingStatus();
        return !licensingStatus.isValid() || ProjectModel.anyJRebelProjects() || ServerConfigProviders.anyServersConfigured();
    }

    private void fixEclipsePerspectives() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor configPerspective = registry.findPerspectiveWithId("org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective");
        if (configPerspective == null) {
            log.warn("ConfigPerspective is not defined");
            return;
        }
        registry.revertPerspective(configPerspective);
        List<IPerspectiveDescriptor> duplicatePerspectives = this.findDuplicatePerspectives(registry, configPerspective);
        log.info("Removing duplicate perspectives: {}", duplicatePerspectives);
        for (IPerspectiveDescriptor p : duplicatePerspectives) {
            registry.deletePerspective(p);
        }
    }

    private List<IPerspectiveDescriptor> findDuplicatePerspectives(IPerspectiveRegistry registry, IPerspectiveDescriptor mainPerspective) {
        PerspectiveDescriptor main = (PerspectiveDescriptor)mainPerspective;
        ArrayList<IPerspectiveDescriptor> duplicatePerspectives = new ArrayList<IPerspectiveDescriptor>();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = registry.getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor p = iPerspectiveDescriptorArray[n2];
            PerspectiveDescriptor perspective = (PerspectiveDescriptor)p;
            if (main.getPluginId().equals(perspective.getPluginId()) && !mainPerspective.getId().equals(perspective.getId()) && mainPerspective.getId().equals(perspective.getOriginalId())) {
                duplicatePerspectives.add((IPerspectiveDescriptor)perspective);
            }
            ++n2;
        }
        return duplicatePerspectives;
    }
}

