/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.components;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.zeroturnaround.eclipse.ui.RebelImage;

public final class FileSelectionComponent
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private Text txtLocation;
    private ImageHyperlink linkLocation;
    private Button btnBrowse;
    private String[] filterExtensions;
    private String[] filterNames;
    private boolean readOnly;
    private String fileNameWhenEmpty;

    public FileSelectionComponent(Composite parent, int style) {
        this(parent, style, true, true);
    }

    public FileSelectionComponent(Composite parent, int style, boolean adaptForToolkit, boolean createExploreButton) {
        super(parent, style);
        this.addDisposeListener(e -> this.toolkit.dispose());
        if (adaptForToolkit) {
            this.toolkit.adapt((Composite)this);
            this.toolkit.paintBordersFor((Composite)this);
        }
        this.mainComposite = adaptForToolkit ? this.toolkit.createComposite((Composite)this) : new Composite((Composite)this, 0);
        this.createLayout();
        this.txtLocation = this.toolkit.createText(this.mainComposite, "", 2048);
        GridData txtLocationGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        txtLocationGridData.widthHint = 100;
        this.txtLocation.setLayoutData((Object)txtLocationGridData);
        if (createExploreButton) {
            this.txtLocation.addModifyListener(e -> this.linkLocation.setEnabled(this.txtLocation.getText().length() > 0));
        }
        this.btnBrowse = this.toolkit.createButton(this.mainComposite, "Browse...", 0);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog fileDialog = new FileDialog(FileSelectionComponent.this.getShell(), 4096);
                if (FileSelectionComponent.this.txtLocation.getText().length() > 0) {
                    File fullPath = new File(FileSelectionComponent.this.txtLocation.getText());
                    File parentDir = fullPath.getParentFile();
                    String path = parentDir != null ? parentDir.getPath() : fullPath.getPath();
                    String name = fullPath.getName();
                    fileDialog.setFilterPath(path);
                    fileDialog.setFileName(name);
                } else if (FileSelectionComponent.this.fileNameWhenEmpty != null) {
                    fileDialog.setFileName(FileSelectionComponent.this.fileNameWhenEmpty);
                }
                if (FileSelectionComponent.this.filterExtensions != null) {
                    fileDialog.setFilterExtensions(FileSelectionComponent.this.filterExtensions);
                }
                if (FileSelectionComponent.this.filterNames != null) {
                    fileDialog.setFilterNames(FileSelectionComponent.this.filterNames);
                }
                if ((file = fileDialog.open()) != null) {
                    FileSelectionComponent.this.setText(file);
                }
            }
        });
        if (createExploreButton) {
            this.linkLocation = this.toolkit.createImageHyperlink(this.mainComposite, 0);
            this.linkLocation.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Program.launch((String)new File(FileSelectionComponent.this.txtLocation.getText()).getParent());
                }
            });
            this.linkLocation.setImage(RebelImage.EXPLORE_FOLDER.getImage());
            if (adaptForToolkit) {
                this.toolkit.paintBordersFor((Composite)this.linkLocation);
            }
            this.linkLocation.setText("Explore");
            this.linkLocation.setEnabled(false);
        }
    }

    private void createLayout() {
        this.setLayout((Layout)new FillLayout());
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
    }

    public String getText() {
        return this.txtLocation.getText();
    }

    public void setText(String text) {
        this.txtLocation.setText(text);
        if (this.linkLocation != null) {
            this.linkLocation.setEnabled(text != null && text.length() > 0);
        }
    }

    public void setEnabled(boolean enabled) {
        this.txtLocation.setEnabled(enabled);
        this.btnBrowse.setEnabled(enabled && !this.readOnly);
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] fileExtensions) {
        this.filterExtensions = fileExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.txtLocation.setEditable(!readOnly);
        this.btnBrowse.setEnabled(!readOnly && this.btnBrowse.getEnabled());
    }

    public String getFileNameWhenEmpty() {
        return this.fileNameWhenEmpty;
    }

    public void setFileNameWhenEmpty(String fileNameWhenEmpty) {
        this.fileNameWhenEmpty = fileNameWhenEmpty;
    }

    public Text getLocationText() {
        return this.txtLocation;
    }
}

