/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.components;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.services.IDisposable;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.common.options.BooleanPref;
import org.zeroturnaround.eclipse.common.options.FilePref;
import org.zeroturnaround.eclipse.common.options.PreferenceOption;

public class PreferenceConfiguration
implements IDisposable {
    public final FilePref jrebelJar;
    public final BooleanPref useGriffin;
    public final BooleanPref autoAddNature;
    public final BooleanPref preLaunchCheck;
    public final BooleanPref debugNewDebuggerLogging;
    public final BooleanPref remotingDebugLog;
    public final PreferenceOption<?>[] options;

    public PreferenceConfiguration() {
        IPreferenceStore prefStore = RebelPlugin.getDefault().getPreferenceStore();
        this.useGriffin = new BooleanPref(prefStore, "jrebelBeta6");
        this.jrebelJar = new FilePref(prefStore, "jrebelJarPath");
        this.autoAddNature = new BooleanPref(prefStore, "jrebelAutoNature");
        this.preLaunchCheck = new BooleanPref(prefStore, "jrebelPreLaunchCheck");
        this.debugNewDebuggerLogging = new BooleanPref(prefStore, "enableDebuggerLogging");
        this.remotingDebugLog = new BooleanPref(prefStore, "jrebel.remoting.debugOutput");
        this.options = new PreferenceOption[]{this.useGriffin, this.jrebelJar, this.autoAddNature, this.preLaunchCheck, this.debugNewDebuggerLogging, this.remotingDebugLog};
    }

    public void resetToDefaults() {
        IPreferenceStore prefStore = RebelPlugin.getDefault().getPreferenceStore();
        PreferenceOption<?>[] preferenceOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceOption<?> opt = preferenceOptionArray[n2];
            prefStore.setToDefault(opt.getName());
            ++n2;
        }
    }

    public void dispose() {
        PreferenceOption<?>[] preferenceOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceOption<?> option = preferenceOptionArray[n2];
            option.dispose();
            ++n2;
        }
    }
}

