/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.components;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.eclipse.config.components.ICheckStateAdapter;

public class ZTCheckboxTreeViewer
extends TreeViewer
implements ICheckable {
    private List<ICheckStateListener> checkStateListeners = new CopyOnWriteArrayList<ICheckStateListener>();
    private ICheckStateAdapter checkStateAdapter;

    public ZTCheckboxTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void setCheckStateAdapter(ICheckStateAdapter checkStateAdapter) {
        this.checkStateAdapter = checkStateAdapter;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        if (!widget.isDisposed() && this.checkStateAdapter != null) {
            this.setChecked(element, this.checkStateAdapter.isChecked(element));
        }
    }

    public void handleSelect(SelectionEvent event) {
        if (event.detail == 32) {
            super.handleSelect(event);
            TreeItem item = (TreeItem)event.item;
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        for (final ICheckStateListener l : this.checkStateListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
        }
        if (this.checkStateAdapter != null) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ZTCheckboxTreeViewer.this.checkStateAdapter.checkStateChanged(event);
                }
            });
        }
    }

    public boolean setChecked(Object element, boolean state) {
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            if (item.getChecked() != state) {
                item.setChecked(state);
            }
            return true;
        }
        return false;
    }

    public boolean setGrayed(Object element, boolean state) {
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            if (item.getGrayed() != state) {
                item.setGrayed(state);
            }
            return true;
        }
        return false;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove(listener);
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getChecked();
        }
        return false;
    }
}

