/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.handlers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective;
import org.zeroturnaround.eclipse.config.ui.JRebelConfigView;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.startup.StartupScenario;

public class JRebelConfigCenter {
    private static final Log log = Log.getInstance(JRebelConfigCenter.class);

    public static void open() {
        JRebelConfigPerspective.deactivateIfActive();
        JRebelConfigView.hideViewIfPresented();
        EclipseUtil.runInUiThread(JRebelConfigCenter::openOverview);
    }

    public static void openActivation() {
        JRebelConfigCenter.closeIntroIfOpen();
        JRebelConfigCenter.openConfigPerspective();
        JRebelConfigView configView = JRebelConfigCenter.getConfigView();
        if (configView != null) {
            configView.openPageActivation();
        }
    }

    public static void openAdvanced() {
        JRebelConfigCenter.closeIntroIfOpen();
        JRebelConfigCenter.openConfigPerspective();
        JRebelConfigView configView = JRebelConfigCenter.getConfigView();
        if (configView != null) {
            configView.openPageAdvanced();
        }
    }

    public static void openOverview() {
        JRebelConfigCenter.closeIntroIfOpen();
        boolean wasOpen = JRebelConfigCenter.isOpen();
        JRebelConfigCenter.openConfigPerspective();
        JRebelConfigView configView = JRebelConfigCenter.getConfigView();
        if (wasOpen && configView != null) {
            configView.openPageOverview();
        }
    }

    public static void openStartup(IWorkbenchWindow window) {
        JRebelConfigCenter.openPage(Pages.PAGE_STARTUP, window);
    }

    public static void openProjects() {
        JRebelConfigCenter.openPage(Pages.PAGE_PROJECTS, null);
    }

    public static void openRemoteServers(Boolean openDialogAutomatically) {
        JRebelConfigCenter.openPage(Pages.PAGE_REMOTE_SERVERS, null, openDialogAutomatically);
    }

    public static void openStartup() {
        JRebelConfigCenter.openStartup(null);
    }

    public static void openStartup(Object scenario) {
        JRebelConfigCenter.openPage(Pages.PAGE_STARTUP, null, scenario);
    }

    private static void openPage(Pages page, IWorkbenchWindow window) {
        JRebelConfigCenter.openPage(page, window, null);
    }

    private static void openPage(Pages page, IWorkbenchWindow window, Object cookie) {
        JRebelConfigCenter.closeIntroIfOpen();
        JRebelConfigCenter.openConfigPerspective(window);
        JRebelConfigView configView = JRebelConfigCenter.getConfigView();
        if (configView != null) {
            switch (page) {
                case PAGE_STARTUP: {
                    configView.openPageStartup((StartupScenario)cookie);
                    break;
                }
                case PAGE_PROJECTS: {
                    configView.openPageProjects();
                    break;
                }
                case PAGE_REMOTE_SERVERS: {
                    configView.openPageRemoteServers((Boolean)cookie);
                    break;
                }
            }
        }
    }

    public static boolean isOpen() {
        AtomicBoolean open = new AtomicBoolean(false);
        Display.getDefault().syncExec(() -> open.set(JRebelConfigCenter.isOpenInUiThread()));
        return open.get();
    }

    private static boolean isOpenInUiThread() {
        try {
            String perspId = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
            return "org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective".equals(perspId);
        }
        catch (Exception e) {
            log.error("Could not detect if config view was open", (Throwable)e);
            return false;
        }
    }

    private static void closeIntroIfOpen() {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart intro = introManager.getIntro();
        if (intro != null) {
            introManager.closeIntro(intro);
        }
    }

    private static JRebelConfigView getConfigView() {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.zeroturnaround.eclipse.config.ui.JRebelConfigView");
        if (view instanceof JRebelConfigView) {
            return (JRebelConfigView)view;
        }
        return null;
    }

    private static void openConfigPerspective() {
        JRebelConfigCenter.openConfigPerspective(null);
    }

    private static void openConfigPerspective(IWorkbenchWindow window) {
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        try {
            PlatformUI.getWorkbench().showPerspective("org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective", window);
        }
        catch (WorkbenchException e) {
            log.error((Throwable)e);
        }
    }

    public static void closeConfigPerspective() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective");
            page.closePerspective(perspective, true, false);
        }
    }

    private static enum Pages {
        PAGE_STARTUP,
        PAGE_PROJECTS,
        PAGE_REMOTE_SERVERS;

    }
}

