/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ProjectModel {
    private static final Log log = Log.getInstance(ProjectModel.class);

    public static IProject[] filterJavaProjects(Object[] elements) {
        ArrayList<IProject> javaProjects = new ArrayList<IProject>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                if (ProjectHelper.hasNature(project, "org.eclipse.jdt.core.javanature")) {
                    javaProjects.add(project);
                }
            } else if (element instanceof JavaProject) {
                javaProjects.add(((JavaProject)element).getProject());
            }
            ++n2;
        }
        ProjectModel.sortProjectList(javaProjects);
        return javaProjects.toArray(new IProject[javaProjects.size()]);
    }

    public static boolean anyJRebelProjects() {
        IProject[] projects;
        IProject[] iProjectArray = projects = EclipseUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (ProjectHelper.isJRebelProject(project)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return false;
    }

    public static List<JRebelProject> getJRebelProjects() {
        IProject[] projects;
        ArrayList<JRebelProject> result = new ArrayList<JRebelProject>();
        IProject[] iProjectArray = projects = EclipseUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                JRebelProject jRebelProject = ProjectHelper.getJRebelProject(project);
                if (jRebelProject != null) {
                    result.add(jRebelProject);
                }
            }
            catch (CoreException e) {
                log.debug((Throwable)e);
            }
            ++n2;
        }
        return result;
    }

    private static void sortProjectList(List<IProject> projects) {
        Collections.sort(projects, new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                if (p1.getName() == null) {
                    return -1;
                }
                return p1.getName().compareTo(p2.getName());
            }
        });
    }
}

