/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.jrebel.ide.common.utils.BuildInfoUtil;

public final class AboutSection
extends Composite {
    private static final String CHANGELOG_URL = "https://jrebel.com/software/jrebel/whats-new/eclipse";
    private static final String EULA_URL = "https://jrebel.com/software/eula/";
    private static final String MANUAL_URL = "https://manuals.jrebel.com/jrebel/ide/eclipse.html?source=eclipse-config";
    private static final String SUPPORT_EMAIL = "mailto:support-rebel@perforce.com";
    private final Composite mainComposite;

    public AboutSection(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = new Composite((Composite)this, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        new ZtLabel(this.mainComposite).text("JRebel for Eclipse " + PlatformInfo.getTrimmedJRebelPluginVersionForRelease()).newline().text(BuildInfoUtil.getCopyrightLabelString((String)PlatformInfo.getTrimmedJRebelPluginVersionForRelease())).newline().text("").newline().image(RebelImage.CHANGELOG.getImage()).link("Changelog", AboutSection.createLinkListener(CHANGELOG_URL)).newline().image(RebelImage.EULA.getImage()).link("End-user license agreement", AboutSection.createLinkListener(EULA_URL)).newline().image(RebelImage.MANUAL.getImage()).link("Reference manual", AboutSection.createLinkListener(MANUAL_URL)).newline().image(RebelImage.EMAIL.getImage()).link("support-rebel@perforce.com", AboutSection.createLinkListener(SUPPORT_EMAIL)).newline();
    }

    private static Listener createLinkListener(final String url) {
        return new Listener(){

            public void handleEvent(Event event) {
                this.openLinkAsync(url);
            }

            private void openLinkAsync(String href) {
                Thread t = new Thread(() -> BrowserUtil.silentOpenLink((String)href), "rebel-mail-link-opener");
                t.setDaemon(true);
                t.start();
            }
        };
    }
}

