/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.common.options.OptionBinding;
import org.zeroturnaround.eclipse.config.components.FileSelectionComponent;
import org.zeroturnaround.eclipse.config.components.PreferenceConfiguration;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.OverviewSection;
import org.zeroturnaround.eclipse.config.ui.dialog.ConfirmSwitchToExternalGenerationDialog;
import org.zeroturnaround.eclipse.config.ui.tools.SwtTools;
import org.zeroturnaround.eclipse.debug.DebuggerIntegration;
import org.zeroturnaround.eclipse.debug.dialog.RestartDialog;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNaturePilot;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableState;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationSource;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.config.LogLevel;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.metrics.MetricsConsent;
import org.zeroturnaround.jrebel.ide.common.notifications.NotificationPermissions;

public final class AdvancedPage
extends AbstractPage {
    private static final Log log = Log.getInstance(AdvancedPage.class);
    private static final String URL_SENDING_LOG = "https://manuals.jrebel.com/jrebel/misc/sendinglogs.html?source=eclipse-config";
    private static Map<MetricsConsent.State, Button> stateToButtonMap;
    private FileSelectionComponent fileLogLocation;
    private final BindingContext context;
    private final PreferenceConfiguration prefsConfig;
    private final Composite mainComposite;
    private static final ISchedulingRule bulkChangeRule;

    static {
        bulkChangeRule = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule;
            }
        };
    }

    public AdvancedPage(Composite parent, IRebelConfigView configView) {
        super(parent, 0, configView, "Advanced");
        this.prefsConfig = configView.getPrefsConfig();
        this.context = new BindingContext();
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite(this);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        this.mainComposite.setLayout((Layout)gridLayout);
        Composite leftColumn = this.toolkit.createComposite(this.mainComposite, 0);
        leftColumn.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.paintBordersFor(leftColumn);
        leftColumn.setLayout((Layout)new GridLayout(1, false));
        Composite rightColumn = this.toolkit.createComposite(this.mainComposite, 0);
        rightColumn.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.toolkit.paintBordersFor(rightColumn);
        rightColumn.setLayout((Layout)new GridLayout(1, false));
        this.createLoggingSection(leftColumn);
        this.createAutoenableSection(leftColumn);
        this.createUsageSection(leftColumn);
        this.createMiscellaneousSection(leftColumn);
        this.createAgentSection(rightColumn);
        this.createRebelXmlGenerationSection(rightColumn);
    }

    private void createLoggingSection(Composite column) {
        Section sctnLogging = this.toolkit.createSection(column, 258);
        sctnLogging.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnLogging);
        sctnLogging.setText("Logging");
        sctnLogging.setExpanded(true);
        Composite loggingComp = this.toolkit.createComposite((Composite)sctnLogging, 0);
        this.toolkit.paintBordersFor(loggingComp);
        sctnLogging.setClient((Control)loggingComp);
        GridLayout loggingCompGridData = new GridLayout(1, false);
        loggingCompGridData.marginWidth = 0;
        loggingCompGridData.marginHeight = 0;
        loggingCompGridData.horizontalSpacing = 0;
        loggingComp.setLayout((Layout)loggingCompGridData);
        Composite logDetailsComp = this.toolkit.createComposite(loggingComp, 0);
        logDetailsComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.paintBordersFor(logDetailsComp);
        logDetailsComp.setLayout((Layout)new GridLayout(5, false));
        this.toolkit.createLabel(logDetailsComp, "JRebel agent log level:", 0);
        this.createLogLevelCombobox(logDetailsComp);
        new Label(logDetailsComp, 0);
        final Button btn = new Button(logDetailsComp, 32);
        this.toolkit.adapt((Control)btn, true, true);
        btn.setText("Enable performance log (slow)");
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        btn.setSelection(((Boolean)this.getConfiguration().performanceLogging().getValue()).booleanValue());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = btn.getSelection();
                AdvancedPage.this.getConfiguration().performanceLogging().setValue((Object)selection);
                AdvancedPage.this.getConfiguration().logThreadDumpingInterval().setValue((Object)(selection ? 5 : 0));
            }
        });
        new Label(logDetailsComp, 0);
        this.createBindedCheckbox(logDetailsComp, this.prefsConfig.remotingDebugLog, "Enable debug logging for remote server communication").setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        Composite logLocationComp = this.toolkit.createComposite(loggingComp, 0);
        logLocationComp.setLayout((Layout)new GridLayout(3, false));
        logLocationComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolkit.paintBordersFor(logLocationComp);
        this.toolkit.createLabel(logLocationComp, "Log File");
        this.fileLogLocation = new FileSelectionComponent(logLocationComp, 0);
        ((GridData)this.fileLogLocation.getLocationText().getLayoutData()).widthHint = -1;
        this.fileLogLocation.setFileNameWhenEmpty("jrebel.log");
        this.fileLogLocation.setFilterNames(new String[]{"JRebel log file (jrebel.log, *.*)"});
        this.fileLogLocation.setFilterExtensions(new String[]{"*.*"});
        this.fileLogLocation.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.adapt(this.fileLogLocation);
        this.toolkit.paintBordersFor(this.fileLogLocation);
        OptionBinding.bind(this.context, this.fileLogLocation, (IOption<File>)this.getConfiguration().logFile());
        ImageHyperlink mghprlnkSetToDefault = this.toolkit.createImageHyperlink(logLocationComp, 0);
        mghprlnkSetToDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AdvancedPage.this.fileLogLocation.setText(((File)AdvancedPage.this.getConfiguration().logFile().getDefaultValue()).getAbsolutePath());
            }
        });
        this.toolkit.paintBordersFor((Composite)mghprlnkSetToDefault);
        mghprlnkSetToDefault.setText("Set to Default");
        Composite composite = this.toolkit.createComposite(loggingComp, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Hyperlink hprlnkHelpWithSending = this.toolkit.createHyperlink(composite, "Help with sending logs", 0);
        hprlnkHelpWithSending.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BrowserUtil.silentOpenLink((String)AdvancedPage.URL_SENDING_LOG);
            }
        });
        this.toolkit.paintBordersFor((Composite)hprlnkHelpWithSending);
    }

    private void createLogLevelCombobox(Composite composite) {
        final Combo comboLogLevel = new Combo(composite, 12);
        final List displayOrder = LogLevel.getPreferredOrder();
        for (LogLevel level : displayOrder) {
            comboLogLevel.add(level.getNameForUI());
        }
        IOption logLevel = this.getConfiguration().logLevel();
        comboLogLevel.select(displayOrder.indexOf(logLevel.getValueOrDefault()));
        comboLogLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedPage.this.getConfiguration().logLevel().setValue((Object)((LogLevel)displayOrder.get(comboLogLevel.getSelectionIndex())));
            }
        });
        OptionBinding.bindListener(this.context, logLevel, option -> comboLogLevel.select(displayOrder.indexOf(option.getValue())));
    }

    private void createAutoenableSection(Composite column) {
        if (!AutoEnableNaturePilot.isInPilot()) {
            return;
        }
        Section sctnAutoenable = this.toolkit.createSection(column, 258);
        sctnAutoenable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnAutoenable);
        sctnAutoenable.setText("Enable JRebel for projects");
        sctnAutoenable.setExpanded(true);
        Composite autoenableComposite = this.toolkit.createComposite((Composite)sctnAutoenable, 0);
        this.toolkit.paintBordersFor(autoenableComposite);
        sctnAutoenable.setClient((Control)autoenableComposite);
        autoenableComposite.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(autoenableComposite, "Enable JRebel for projects created or imported", 0);
        final Combo combo = new Combo(autoenableComposite, 12);
        AutoEnableState[] autoEnableStateArray = AutoEnableState.values();
        int n = autoEnableStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            AutoEnableState state = autoEnableStateArray[n2];
            combo.add(state.uiName);
            ++n2;
        }
        final IOption<AutoEnableState> autoenableStateOption = AutoEnableState.configOption(this.getConfiguration());
        combo.select(((AutoEnableState)((Object)autoenableStateOption.getValue())).listIndex());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoEnableState selectedState = AutoEnableState.fromListIndex(combo.getSelectionIndex());
                if (selectedState != null) {
                    autoenableStateOption.setValue((Object)selectedState);
                }
            }
        });
        OptionBinding.bindListener(this.context, autoenableStateOption, option -> combo.select(((AutoEnableState)((Object)((Object)option.getValue()))).ordinal()));
    }

    private void createUsageSection(Composite column) {
        Section section = this.toolkit.createSection(column, 258);
        section.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)section);
        section.setText("Usage and environment data");
        section.setExpanded(true);
        Composite parent = this.toolkit.createComposite((Composite)section, 0);
        this.toolkit.paintBordersFor(parent);
        section.setClient((Control)parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        Label description = new Label(parent, 0);
        String text = "JRebel collects various usage and environment data for product improvements and support. This \nincludes, but is not limited to: operating system, IDE type and version, JVM type and version, \napplication server type and version, JRebel usage data, and JRebel settings.\n\nSwitching to anonymous reporting or disabling reporting will revoke consent for collecting \npersonally identifiable usage and environment data.";
        description.setText(text);
        description.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        SwtTools.addSpacing(parent, 2);
        Button fullDataButton = this.createButton(parent, "Report usage data", 1);
        Hyperlink moreInfoLink = this.toolkit.createHyperlink(parent, "More info", 0);
        moreInfoLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        moreInfoLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BrowserUtil.silentOpenLink((String)"https://jrebel.com/legal/jrebel-data-reporting");
            }
        });
        this.toolkit.paintBordersFor((Composite)moreInfoLink);
        Button anonymousDataButton = this.createButton(parent, "Report data anonymously", 2);
        Button noDataButton = this.createButton(parent, "Disable reporting", 2);
        this.setupListener(fullDataButton, anonymousDataButton, noDataButton);
    }

    private Button createButton(Composite parent, String label, int columns) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, columns, 1));
        this.toolkit.adapt((Control)button, true, true);
        return button;
    }

    private void setupListener(Button fullDataButton, Button anonymousDataButton, Button noDataButton) {
        stateToButtonMap = new HashMap<MetricsConsent.State, Button>();
        stateToButtonMap.put(MetricsConsent.State.PERSONAL_METRICS, fullDataButton);
        stateToButtonMap.put(MetricsConsent.State.ANONYMOUS_METRICS, anonymousDataButton);
        stateToButtonMap.put(MetricsConsent.State.NO_METRICS, noDataButton);
        this.selectCorrectState(stateToButtonMap);
        for (Map.Entry<MetricsConsent.State, Button> entry : stateToButtonMap.entrySet()) {
            final MetricsConsent.State state = entry.getKey();
            final Button button = entry.getValue();
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection() && MetricsConsent.getState() != state) {
                        if (state == MetricsConsent.State.PERSONAL_METRICS) {
                            MetricsConsent.DialogResultCallback callback = new MetricsConsent.DialogResultCallback(){

                                public void onResult(boolean result) {
                                    if (result) {
                                        MetricsConsent.setState((MetricsConsent.State)state);
                                    } else {
                                        EclipseUtil.runInUiThread(() -> AdvancedPage.this.selectCorrectState(stateToButtonMap));
                                    }
                                }
                            };
                            boolean dialogOpened = MetricsConsent.getInstance().showDialogIfPossible(callback);
                            if (!dialogOpened) {
                                MetricsConsent.setState((MetricsConsent.State)MetricsConsent.State.ANONYMOUS_METRICS);
                            }
                        } else {
                            MetricsConsent.setState((MetricsConsent.State)state);
                        }
                    }
                }
            });
        }
    }

    private void selectCorrectState(Map<MetricsConsent.State, Button> stateToButtonMap) {
        MetricsConsent.State currentState = MetricsConsent.getState();
        AdvancedPage.selectCorrectState(stateToButtonMap, currentState);
    }

    private static void selectCorrectState(Map<MetricsConsent.State, Button> stateToButtonMap, MetricsConsent.State currentState) {
        for (Map.Entry<MetricsConsent.State, Button> entry : stateToButtonMap.entrySet()) {
            entry.getValue().setSelection(entry.getKey() == currentState);
        }
    }

    private void createMiscellaneousSection(Composite column) {
        Section sctnMiscellaneous = this.toolkit.createSection(column, 258);
        sctnMiscellaneous.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnMiscellaneous);
        sctnMiscellaneous.setText("Miscellaneous");
        sctnMiscellaneous.setExpanded(true);
        Composite miscellaneousComposite = this.toolkit.createComposite((Composite)sctnMiscellaneous, 0);
        this.toolkit.paintBordersFor(miscellaneousComposite);
        sctnMiscellaneous.setClient((Control)miscellaneousComposite);
        miscellaneousComposite.setLayout((Layout)new GridLayout(1, false));
        this.createBindedCheckbox(miscellaneousComposite, this.prefsConfig.debugNewDebuggerLogging, "Enable VM debugger logging (requires Eclipse restart)", String.format("The log is stored in %s file. The new setting will not take effect until IDE restart.", String.valueOf(JRebelConfiguration.getUserHomeDir().getAbsolutePath()) + File.separator + DebuggerIntegration.getTargetLogName()));
        this.createBindedCheckbox(miscellaneousComposite, this.prefsConfig.preLaunchCheck, "Prompt to launch with JRebel agent for JRebel-enabled applications");
        IValueChangedListener<Boolean> restartListener = new IValueChangedListener<Boolean>(){

            public void valueChanged(IOption<Boolean> option) {
                if (RestartDialog.openQuestion(AdvancedPage.this.getShell())) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        };
        OptionBinding.bindListener(this.context, this.prefsConfig.debugNewDebuggerLogging, restartListener);
        Hyperlink linkResetNotificationPrefs = this.toolkit.createHyperlink(miscellaneousComposite, "Restore default settings for JRebel notifications", 0);
        linkResetNotificationPrefs.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ResetBlockedNotificationsDialog dialog = new ResetBlockedNotificationsDialog(AdvancedPage.this.getParent().getShell());
                if (dialog.open() == 0) {
                    NotificationPermissions.resetBlockedTypes();
                }
            }
        });
        this.toolkit.paintBordersFor((Composite)linkResetNotificationPrefs);
    }

    private void createAgentSection(Composite column) {
        Section sctnAgent = this.toolkit.createSection(column, 354);
        sctnAgent.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnAgent);
        sctnAgent.setText("JRebel Agent");
        sctnAgent.setExpanded(true);
        OverviewSection overviewSection = new OverviewSection((Composite)sctnAgent, 64, this.configView);
        sctnAgent.setClient((Control)overviewSection);
        this.disposables.add(overviewSection);
    }

    private void createRebelXmlGenerationSection(Composite column) {
        Section section = this.toolkit.createSection(column, 354);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)section);
        section.setText("rebel.xml generation");
        section.setExpanded(true);
        this.createRebelXmlGenerationSectionComposite(section);
    }

    private void createRebelXmlGenerationSectionComposite(final Section section) {
        Composite composite = this.toolkit.createComposite((Composite)section, 0);
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Pair<List<EclipseIdeProject>, List<EclipseIdeProject>> ideExternalGenerationModules = RebelXmlGenerationSource.getIdeExternalGenerationModules();
        int ideGenerationCount = ((List)ideExternalGenerationModules.getLeft()).size();
        int externalGenerationCount = ((List)ideExternalGenerationModules.getRight()).size();
        new ZtLabel(composite).text("Each project requires a rebel.xml configuration file to be reloadable with JRebel.").newline().text("By default, these files are generated by the JRebel IDE plugin.");
        SwtTools.addSpacing(composite);
        new ZtLabel(composite).macSafeBold(String.valueOf(ideGenerationCount > 0 ? String.valueOf(ideGenerationCount) : "No") + " open " + this.plural("project", ideGenerationCount)).text(String.valueOf(this.plural("is", ideGenerationCount)) + " configured to use JRebel IDE plugin rebel.xml generation.").newline().macSafeBold(String.valueOf(externalGenerationCount > 0 ? String.valueOf(externalGenerationCount) : "No") + " open " + this.plural("project", externalGenerationCount)).text(String.valueOf(this.plural("is", externalGenerationCount)) + " configured to use external rebel.xml generation.");
        SwtTools.addSpacing(composite);
        ArrayList<Control> links = new ArrayList<Control>();
        final RebelXmlGenerationSource generator = new RebelXmlGenerationSource();
        ZtLabel convertToIdeGenerationLabel = new ZtLabel(composite).link("Switch projects to IDE generation", e -> {
            log.debug("Will switch projects to ide generation");
            this.disable(links);
            Job job = new Job("Switching projects to IDE rebel.xml generation"){

                protected IStatus run(IProgressMonitor monitor) {
                    generator.convertAllToIdeGenerationBulk();
                    EclipseUtil.runInUiThread(() -> AdvancedPage.this.refreshRebelXmlGenerationSection(section));
                    return Status.OK_STATUS;
                }
            };
            job.setRule(bulkChangeRule);
            job.schedule();
        });
        links.add(convertToIdeGenerationLabel.lastDisableableObject());
        ZtLabel convertToExtGenerationLabel = new ZtLabel(composite).link("Switch projects to external build tool generation", e -> {
            final List modulesToConvert = (List)RebelXmlGenerationSource.getIdeExternalGenerationModules().getLeft();
            if (modulesToConvert.isEmpty()) {
                log.info("No modules to convert to external - not showing dialog, doing nothing");
                return;
            }
            boolean result = ConfirmSwitchToExternalGenerationDialog.openQuestion(this.getShell(), modulesToConvert);
            if (result) {
                log.debug("Will switch {} projects to external generation", (Object)modulesToConvert.size());
                this.disable(links);
                Job job = new Job("Switching projects to external rebel.xml generation"){

                    protected IStatus run(IProgressMonitor monitor) {
                        generator.convertToExternalGenerationBlockingBulk(modulesToConvert);
                        EclipseUtil.runInUiThread(() -> AdvancedPage.this.refreshRebelXmlGenerationSection(section));
                        return Status.OK_STATUS;
                    }
                };
                job.setRule(bulkChangeRule);
                job.schedule();
            }
        });
        links.add(convertToExtGenerationLabel.lastDisableableObject());
        SwtTools.addSpacing(composite);
        final Button noAutoConvertButton = new Button(composite, 32);
        noAutoConvertButton.setText("Never switch projects to external rebel.xml generation automatically");
        boolean value = IdeInstance.getInstance().isExternalAutoconvertDisabled();
        noAutoConvertButton.setSelection(value);
        noAutoConvertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdeInstance.getInstance().setExternalAutoconvertDisabled(noAutoConvertButton.getSelection());
            }
        });
    }

    private void disable(List<Control> controls) {
        for (Control control : controls) {
            control.setEnabled(false);
        }
    }

    private void refreshRebelXmlGenerationSection(Section section) {
        if (!this.isDisposed()) {
            section.getClient().dispose();
            this.createRebelXmlGenerationSectionComposite(section);
            this.layout(false, true);
        }
    }

    private String plural(String text, int count) {
        boolean single = count == 1;
        switch (text) {
            case "project": {
                return single ? text : String.valueOf(text) + "s";
            }
            case "is": {
                return single ? "is" : "are";
            }
        }
        throw new IllegalArgumentException("unexpected string '" + text + "'");
    }

    private Button createBindedCheckbox(Composite parent, IOption<Boolean> bindedOption, String text) {
        return this.createBindedCheckbox(parent, bindedOption, text, null);
    }

    private Button createBindedCheckbox(Composite parent, IOption<Boolean> bindedOption, String text, String tooltipText) {
        Button btn = new Button(parent, 32);
        this.toolkit.adapt((Control)btn, true, true);
        btn.setText(text);
        btn.setToolTipText(tooltipText);
        OptionBinding.bind(this.context, btn, bindedOption);
        return btn;
    }

    public JRebelConfiguration getConfiguration() {
        return this.configView.getConfiguration();
    }

    @Override
    public void dispose() {
        this.context.unbindAll();
        stateToButtonMap = null;
        super.dispose();
    }

    public static class ConsentButtonsStateUpdater
    implements MetricsConsent.DialogResultCallback {
        public void onResult(final boolean result) {
            EclipseUtil.runInUiThread(new Runnable(){

                @Override
                public void run() {
                    if (stateToButtonMap != null) {
                        AdvancedPage.selectCorrectState(stateToButtonMap, result ? MetricsConsent.State.PERSONAL_METRICS : MetricsConsent.State.ANONYMOUS_METRICS);
                    }
                }
            });
        }
    }

    private static class ResetBlockedNotificationsDialog
    extends MessageDialog {
        private static final String[] yesCancel = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL};

        private ResetBlockedNotificationsDialog(Shell parentShell) {
            super(parentShell, "Reset JRebel notification settings?", RebelImage.JREBEL.getImage(), "This will reset your JRebel notification settings. Are you sure?", 3, yesCancel, 0);
        }
    }
}

