/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.zeroturnaround.eclipse.config.components.PartLifecycleAdapter;
import org.zeroturnaround.eclipse.config.components.PreferenceConfiguration;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.AdvancedPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.OverviewPage;
import org.zeroturnaround.eclipse.config.ui.RemoteServersPage;
import org.zeroturnaround.eclipse.config.ui.StartupPage;
import org.zeroturnaround.eclipse.config.ui.newactivation.ActivationDialogNew;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsPage;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.startup.StartupScenario;

public class JRebelConfigView
extends ViewPart
implements IRebelConfigView {
    private static final Log log = Log.getInstance(JRebelConfigView.class);
    public static final String ID = "org.zeroturnaround.eclipse.config.ui.JRebelConfigView";
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final JRebelConfiguration configuration = JRebelConfiguration.getDefault();
    private final PreferenceConfiguration prefsConfig = new PreferenceConfiguration();
    private final List<Composite> disposables = new ArrayList<Composite>();
    private Form form;
    private CTabFolder tabFolder;
    private List<AbstractPage> pages;
    private OverviewPage overviewPage;
    private Action backAction;
    private Action closeAction;
    private IPerspectiveListener perspectiveListener;

    public void createPartControl(Composite parent) {
        this.loadConfiguration();
        this.createActions();
        Composite container = this.toolkit.createComposite(parent, 0);
        this.toolkit.paintBordersFor(container);
        container.setLayout((Layout)new FillLayout(256));
        this.form = this.toolkit.createForm(container);
        this.form.setImage(RebelImage.JREBEL.getImage());
        this.toolkit.paintBordersFor((Composite)this.form);
        this.toolkit.decorateFormHeading(this.form);
        this.form.setText("JRebel Configuration");
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        this.form.getBody().setLayout((Layout)gridLayout);
        this.form.getToolBarManager().add((IAction)this.backAction);
        this.form.getToolBarManager().add((IAction)this.closeAction);
        this.form.getToolBarManager().update(true);
        this.tabFolder = new CTabFolder(this.form.getBody(), 0x800800);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tabFolder.setSimple(false);
        this.toolkit.adapt((Composite)this.tabFolder);
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelConfigView.this.form.setText("JRebel Configuration");
                JRebelConfigView.this.backAction.setEnabled(JRebelConfigView.this.tabFolder.getSelectionIndex() > 0);
                ((AbstractPage)JRebelConfigView.this.tabFolder.getSelection().getControl()).onTabSelected();
            }
        });
        this.pages = new ArrayList<AbstractPage>();
        this.overviewPage = new OverviewPage((Composite)this.tabFolder, this);
        this.pages.add(this.overviewPage);
        this.pages.add(new ProjectsPage((Composite)this.tabFolder, this));
        this.pages.add(new StartupPage((Composite)this.tabFolder, this));
        this.pages.add(new RemoteServersPage((Composite)this.tabFolder, this));
        this.pages.add(new AdvancedPage((Composite)this.tabFolder, this));
        for (AbstractPage page : this.pages) {
            this.configureTabItem(page);
        }
        this.setupPerspectiveListener();
        this.openPageOverview();
    }

    public static boolean hideViewIfPresented() {
        boolean found = false;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView(ID);
        if (view != null) {
            found = true;
            page.hideView(view);
        }
        return found;
    }

    private void setupPerspectiveListener() {
        this.perspectiveListener = this.createPerspectiveListener();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
    }

    private IPerspectiveListener createPerspectiveListener() {
        return new IPerspectiveListener(){

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if ("org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective".equals(perspective.getId())) {
                    for (AbstractPage tabItem : JRebelConfigView.this.pages) {
                        tabItem.updateContent();
                    }
                }
            }
        };
    }

    private void configureTabItem(AbstractPage page) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(page.getPageTitle());
        tabItem.setControl((Control)page);
        this.toolkit.paintBordersFor((Composite)page);
        this.disposables.add(page);
    }

    private void loadConfiguration() {
        this.configuration.init();
    }

    public void dispose() {
        this.prefsConfig.dispose();
        for (Composite disposable : this.disposables) {
            disposable.dispose();
        }
        this.toolkit.dispose();
        if (this.perspectiveListener != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.removePerspectiveListener(this.perspectiveListener);
                ++n2;
            }
        }
        super.dispose();
    }

    private void createActions() {
        this.backAction = new Action("Back to Overview", RebelImage.BACKWARDS_NAV.getDescriptor()){

            public void run() {
                JRebelConfigView.this.openPageOverview();
            }
        };
        this.closeAction = new Action("Close Perspective", RebelImage.CLOSE_PERSPECTIVE.getDescriptor()){

            public void run() {
                JRebelConfigCenter.closeConfigPerspective();
            }
        };
    }

    public void setFocus() {
    }

    @Override
    public JRebelConfiguration getConfiguration() {
        return this.configuration;
    }

    public void openPageOverview() {
        this.setTabFolderSelectionToClass(OverviewPage.class);
    }

    public void openPageStartup(StartupScenario scenario) {
        StartupPage page = this.setTabFolderSelectionToClass(StartupPage.class);
        if (page != null) {
            page.selectScenario(scenario);
        }
    }

    public void openPageProjects() {
        this.setTabFolderSelectionToClass(ProjectsPage.class);
    }

    public void openPageRemoteServers(boolean openDialogAutomatically) {
        RemoteServersPage page = this.setTabFolderSelectionToClass(RemoteServersPage.class);
        if (openDialogAutomatically && page != null) {
            page.openRemoteServerDialog();
        }
    }

    @Override
    public void openPageAdvanced() {
        this.setTabFolderSelectionToClass(AdvancedPage.class);
    }

    private <T extends AbstractPage> T setTabFolderSelectionToClass(Class<T> pageClass) {
        CTabItem[] items = this.tabFolder.getItems();
        AbstractPage c = null;
        CTabItem[] cTabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (pageClass.equals(item.getControl().getClass())) {
                this.tabFolder.setSelection(item);
                c = (AbstractPage)item.getControl();
                break;
            }
            ++n2;
        }
        this.tabFolder.notifyListeners(13, null);
        return (T)((Object)c);
    }

    @Override
    public void openPageActivation() {
        LicensingStatus status = Watcher.getInstance().getLastLicensingStatus();
        new ActivationDialogNew(this.getOverviewPage().getShell(), status).open();
    }

    @Override
    public PreferenceConfiguration getPrefsConfig() {
        return this.prefsConfig;
    }

    @Override
    public OverviewPage getOverviewPage() {
        return this.overviewPage;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IPerspectiveDescriptor currentPerspective = site.getPage().getPerspective();
        if (!"org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective".equals(currentPerspective.getId())) {
            log.error(String.format("JRebel Configuration view can only be opened in the JRebel Configuration perspective! Current perspective: %s", currentPerspective.getId()));
            throw new PartInitException("The JRebel Configuration view can only be opened via the JRebel Configuration perspective. First close the current view, then open Help > JRebel > Configuration.");
        }
        site.getPage().addPartListener((IPartListener2)new PartLifecycleAdapter(){

            @Override
            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPage page;
                IPerspectiveDescriptor perspective;
                IEditorReference[] editorReferences;
                boolean keepEditorsVisible = false;
                IEditorReference[] iEditorReferenceArray = editorReferences = partRef.getPage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference edRef = iEditorReferenceArray[n2];
                    if ("org.eclipse.wst.server.ui.editor".equals(edRef.getId())) {
                        keepEditorsVisible = true;
                        break;
                    }
                    if ("rebel.xml".equals(edRef.getName())) {
                        keepEditorsVisible = true;
                        break;
                    }
                    ++n2;
                }
                if (!keepEditorsVisible && (perspective = (page = partRef.getPage()).getPerspective()) != null && "org.zeroturnaround.eclipse.config.ui.JRebelConfigPerspective".equals(perspective.getId())) {
                    page.setEditorAreaVisible(false);
                }
            }
        });
    }
}

