/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.common.util.LicenseUtils;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.common.options.OptionBinding;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.LicenseSource;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.javarebel.LicensingMessage;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.utils.AutoRenewOfflineSeatScheduler;

public final class LicenseServerSection
extends Composite {
    private static final Log log = Log.getInstance(LicenseServerSection.class);
    private static final String MESSAGE_GO_ONLINE = "Work online";
    private static final String MESSAGE_GO_OFFLINE = "Work offline";
    private static final String MESSAGE_RENEW_OFFLINE_SEAT = "Renew offline seat";
    private static final String MESSAGE_NO_LEASE_TAKEN = "";
    private static final String MESSAGE_OFFLINE_SEAT_DURATION = "Offline seat duration";
    private static final String MESSAGE_AUTORENEW_OFFLINE_SEAT = "Automatically renew offline seat";
    private static final String MESSAGE_LEASE_EXPIRES = "Offline seat expires";
    private static final String OFFLINE_SEAT_INFO_URL = "https://manuals.jrebel.com/license-server/configuration/client-configuration.html#offline-seats";
    private static final String MESSAGE_OFFLINE_SEAT_INFO = "More info on offline seats";
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private BindingContext bindingContext = new BindingContext();
    private Button btnWorkOffline;
    private Button btnWorkOnline;
    private Label offlineLease;
    private IRebelConfigView configView;
    private Composite offlineLeaseDurationComposite;
    private Spinner spinner;
    private final Watcher.Listener licensingListener;
    private ZtLabel warningMessage;

    public LicenseServerSection(Composite parent, int style, IRebelConfigView configView) {
        super(parent, style);
        this.configView = configView;
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite((Composite)this);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        Composite compositeNotification = this.toolkit.createComposite(this.mainComposite, 0);
        compositeNotification.setLayout((Layout)new FillLayout(256));
        compositeNotification.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.toolkit.paintBordersFor(compositeNotification);
        this.warningMessage = new ZtLabel(compositeNotification);
        Composite composite = this.toolkit.createComposite(this.mainComposite, 0);
        GridLayout compositeGridLayout = new GridLayout(4, false);
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.toolkit.paintBordersFor(composite);
        this.btnWorkOffline = this.toolkit.createButton(composite, MESSAGE_GO_OFFLINE, 0);
        this.btnWorkOffline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    Watcher.getInstance().getLicensing().goOffline(((Integer)LicenseServerSection.this.getConfiguration().offlineLeaseDuration().getValueOrDefault()).intValue());
                }
                catch (Licensing.ActivationException e) {
                    log.error((Throwable)e);
                    LicenseServerSection.this.showNotification(true, JRebelLicensing.getActivationExceptionFaultString((Licensing.ActivationException)e));
                }
            }
        });
        this.btnWorkOnline = this.toolkit.createButton(composite, MESSAGE_GO_ONLINE, 0);
        this.btnWorkOnline.setVisible(false);
        this.offlineLease = this.toolkit.createLabel(composite, MESSAGE_NO_LEASE_TAKEN, 0);
        this.offlineLease.setEnabled(false);
        this.offlineLease.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.offlineLeaseDurationComposite = this.toolkit.createComposite(composite, 0);
        GridLayout offlineLeaseDurationCompositeGridData = new GridLayout(3, false);
        offlineLeaseDurationCompositeGridData.horizontalSpacing = 2;
        offlineLeaseDurationCompositeGridData.marginWidth = 0;
        offlineLeaseDurationCompositeGridData.marginHeight = 0;
        this.offlineLeaseDurationComposite.setLayout((Layout)offlineLeaseDurationCompositeGridData);
        this.offlineLeaseDurationComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolkit.paintBordersFor(this.offlineLeaseDurationComposite);
        this.toolkit.createLabel(this.offlineLeaseDurationComposite, MESSAGE_OFFLINE_SEAT_DURATION, 0);
        this.spinner = new Spinner(this.offlineLeaseDurationComposite, 2048);
        this.spinner.setPageIncrement(5);
        this.spinner.setMaximum(15);
        this.spinner.setMinimum(1);
        this.spinner.setSelection(1);
        this.toolkit.adapt((Composite)this.spinner);
        this.toolkit.paintBordersFor((Composite)this.spinner);
        OptionBinding.bind(this.bindingContext, this.spinner, (IOption<Integer>)this.getConfiguration().offlineLeaseDuration());
        this.toolkit.createLabel(this.offlineLeaseDurationComposite, "days", 0);
        this.btnWorkOnline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Watcher.getInstance().getLicensing().goOnline();
                }
                catch (Licensing.ActivationException e1) {
                    LicenseServerSection.this.showNotification(true, JRebelLicensing.getActivationExceptionFaultString((Licensing.ActivationException)e1));
                    log.error((Throwable)e1);
                }
            }
        });
        Composite panelMoreInfoAutorenew = this.toolkit.createComposite(composite);
        GridLayout theLayout = new GridLayout(3, false);
        theLayout.marginHeight = 0;
        theLayout.marginWidth = 0;
        panelMoreInfoAutorenew.setLayout((Layout)theLayout);
        panelMoreInfoAutorenew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        Hyperlink moreInfoLink = this.toolkit.createHyperlink(panelMoreInfoAutorenew, MESSAGE_OFFLINE_SEAT_INFO, 0);
        moreInfoLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BrowserUtil.silentOpenLink((String)LicenseServerSection.OFFLINE_SEAT_INFO_URL);
            }
        });
        moreInfoLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Label centerFiller = new Label(panelMoreInfoAutorenew, 0);
        centerFiller.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Button checkboxAutorenewOfflineSeat = this.toolkit.createButton(panelMoreInfoAutorenew, MESSAGE_AUTORENEW_OFFLINE_SEAT, 32);
        checkboxAutorenewOfflineSeat.setSelection(AutoRenewOfflineSeatScheduler.isLSAutorenewOffline());
        checkboxAutorenewOfflineSeat.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        checkboxAutorenewOfflineSeat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button btn = (Button)se.getSource();
                boolean selected = btn.getSelection();
                AutoRenewOfflineSeatScheduler.setLSAutorenewOffline((boolean)selected);
            }
        });
        this.licensingListener = new Watcher.Listener(){

            public void licenseStatusChanged(final LicensingStatus newStatus) {
                EclipseUtil.runInUiThread(new Runnable(){

                    @Override
                    public void run() {
                        LicenseServerSection.this.licenseChangedInUi(newStatus);
                        SWTUtil.revalidateLayout((Control)LicenseServerSection.this.getParent());
                    }
                });
            }
        };
        Watcher.getInstance().listenForRealLicenseStatus(this.licensingListener);
    }

    private void showNotification(boolean enable, LicensingMessage message) {
        this.beforeLicenseCheck();
        if (enable) {
            String text = message.getText();
            text = text.replace("Refer to", "<br /> Refer to");
            this.warningMessage.image(RebelImage.DANGER.getImage()).fromText(text, event -> BrowserUtil.silentOpenLink((String)event.text)).newline();
        }
        SWTUtil.revalidateLayout((Control)this);
    }

    private void licenseChangedInUi(LicensingStatus status) {
        boolean usingLicenseServer = status.hasLicense() && LicenseSource.SERVER == status.license.getLicenseSource();
        this.beforeLicenseCheck();
        this.spinner.setEnabled(usingLicenseServer);
        this.offlineLease.setVisible(true);
        this.btnWorkOffline.setVisible(true);
        this.offlineLeaseDurationComposite.setVisible(true);
        if (usingLicenseServer) {
            Licensing.SDKLicenseInfo license = status.license;
            Calendar leaseValidUntil = license.getValidUntil();
            Calendar now = Calendar.getInstance();
            if (license.isOfflineLease() && leaseValidUntil != null && now.before(leaseValidUntil)) {
                this.btnWorkOffline.setText(MESSAGE_RENEW_OFFLINE_SEAT);
                this.btnWorkOffline.setEnabled(true);
                this.btnWorkOnline.setEnabled(true);
                this.btnWorkOnline.setVisible(true);
                String format = LicenseUtils.getExpiryDateDisplayStringForOfflineLease((Date)leaseValidUntil.getTime());
                this.offlineLease.setText("Offline seat expires " + format);
                this.offlineLease.setEnabled(true);
            } else {
                this.btnWorkOffline.setText(MESSAGE_GO_OFFLINE);
                this.btnWorkOffline.setEnabled(true);
                this.btnWorkOnline.setEnabled(false);
                this.btnWorkOnline.setVisible(false);
                this.offlineLease.setText(MESSAGE_NO_LEASE_TAKEN);
                this.offlineLease.setEnabled(false);
            }
        } else {
            this.offlineLease.setText(MESSAGE_NO_LEASE_TAKEN);
            this.offlineLease.setEnabled(false);
            this.btnWorkOffline.setText(MESSAGE_GO_OFFLINE);
            this.btnWorkOffline.setEnabled(false);
            this.btnWorkOnline.setEnabled(false);
        }
        SWTUtil.revalidateLayout((Control)this);
    }

    public void dispose() {
        Watcher.getInstance().removeLicenseChangeListener(this.licensingListener);
        this.bindingContext.unbindAll();
        super.dispose();
    }

    private JRebelConfiguration getConfiguration() {
        return this.configView.getConfiguration();
    }

    void beforeLicenseCheck() {
        this.warningMessage.clear();
        SWTUtil.revalidateLayout((Control)this);
    }
}

