/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import java.io.File;
import java.net.URI;
import java.util.Date;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.common.util.IdeStringUtils;
import org.zeroturnaround.common.util.LicenseUtils;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.LicenseServerSection;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.javarebel.WebLink;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;

public final class LicensingSection
extends Composite {
    private static final String MESSAGE_NO_LICENSE = "Activate JRebel";
    private static final String MESSAGE_HAS_LICENSE = "Change license";
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private ZtLabel licensingText;
    private Composite licenseServerWrapper;
    private LicenseServerSection licenseServerComp = null;
    private IRebelConfigView configView;
    private ImageHyperlink updateLicenseLink;
    private final Watcher.Listener licensingListener;

    public LicensingSection(Composite parent, int style, final IRebelConfigView configView) {
        super(parent, style);
        this.configView = configView;
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite((Composite)this);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite licensingTextWrapper = new Composite(this.mainComposite, 0);
        licensingTextWrapper.setLayout((Layout)new GridLayout(2, false));
        licensingTextWrapper.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.licensingText = new ZtLabel(licensingTextWrapper);
        this.toolkit.createFormText(this.mainComposite, false).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.licensingText.text("Please wait, querying for license information...");
        this.licenseServerWrapper = new Composite(this.mainComposite, 0);
        this.licenseServerWrapper.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt(this.licenseServerWrapper);
        this.toolkit.paintBordersFor(this.licenseServerWrapper);
        this.licenseServerWrapper.setLayout((Layout)new FillLayout(256));
        this.updateLicenseLink = this.toolkit.createImageHyperlink(licensingTextWrapper, 0);
        this.updateLicenseLink.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.updateLicenseLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                configView.openPageActivation();
            }
        });
        this.updateLicenseLink.setImage(RebelImage.PAGE.getImage());
        this.updateLicenseLink.setVisible(false);
        this.toolkit.paintBordersFor((Composite)this.updateLicenseLink);
        this.updateLicenseLink.setText(MESSAGE_NO_LICENSE);
        this.licensingListener = new Watcher.Listener(){

            public void licenseStatusChanged(LicensingStatus newStatus) {
                EclipseUtil.runInUiThread(() -> LicensingSection.this.licenseChangedInUi(newStatus));
            }
        };
        Watcher.getInstance().listenForRealLicenseStatus(this.licensingListener);
    }

    private void licenseChangedInUi(LicensingStatus status) {
        this.licensingText.clear();
        if (status.hasLicense()) {
            Licensing.SDKLicenseInfo license = status.license;
            if (status.hasError()) {
                this.licensingText.image(RebelImage.WARNING.getImage()).text(status.errorMessage.getDescription()).text(status.errorMessage.getCallToAction());
                WebLink link = status.errorMessage.getWebLink();
                if (link != null) {
                    this.licensingText.link(link.getDescription(), LicensingSection.createListener(link.getLink()));
                }
                this.licensingText.newline();
            }
            if (license.getLicenseeName() != null) {
                this.licensingText.text("Licensed to: " + license.getLicenseeName()).newline();
            }
            if (license.getAdditionalInfo() != null) {
                this.licensingText.text(license.getAdditionalInfo()).newline();
            }
            if (license.getValidUntil() != null && !status.hasServerLicense()) {
                String format = LicenseUtils.getExpiryDateDisplayStringForDedicatedLicense((Date)license.getValidUntil().getTime());
                this.licensingText.text("Valid until " + format).newline();
            }
            if (license.getLicenseFile() != null) {
                File file = license.getLicenseFile();
                int maxLicensePathLenght = 60;
                this.licensingText.text("License loaded from file: ").image(RebelImage.EXPLORE_FOLDER.getImage()).link(IdeStringUtils.shortenFilePath((File)file, (int)maxLicensePathLenght), LicensingSection.createListener(file.getParentFile().toURI()));
                String licensePath = file.getAbsolutePath();
                if (licensePath.length() > maxLicensePathLenght) {
                    this.licensingText.tooltip(licensePath);
                }
                this.licensingText.newline();
            }
            if (status.hasServerLicense()) {
                URI licenseLoc = license.getLicenseLocation();
                String licenseText = this.getServerDescription(license);
                String licenseUrl = "";
                if (licenseLoc != null) {
                    licenseText = String.valueOf(licenseText) + " @ ";
                    licenseUrl = licenseLoc.getPort() == 443 ? String.valueOf(licenseUrl) + licenseLoc.toString().replaceFirst(":443", "") : (licenseLoc.getPort() == 80 ? String.valueOf(licenseUrl) + licenseLoc.toString().replaceFirst(":80", "") : String.valueOf(licenseUrl) + licenseLoc);
                }
                this.licensingText.text(licenseText).link(licenseUrl, LicensingSection.createListener(licenseLoc)).newline();
            }
        } else {
            this.licensingText.text(IdeStringUtils.extractJSONFieldIfDetected((String)"content", (String)status.errorMessage.getText()));
        }
        this.updateLicenseServerComponent(status);
        this.updateLicenseLink.setText(status.isValid() ? MESSAGE_HAS_LICENSE : MESSAGE_NO_LICENSE);
        this.updateLicenseLink.setVisible(true);
    }

    private static Listener createListener(final URI uri) {
        if (uri == null) {
            return event -> {};
        }
        return new Listener(){

            public void handleEvent(Event event) {
                String href = uri.toString();
                if (href.startsWith("http:") || href.startsWith("https:")) {
                    BrowserUtil.silentOpenLink((String)href);
                } else {
                    Program.launch((String)href);
                }
            }
        };
    }

    private void updateLicenseServerComponent(LicensingStatus status) {
        if (this.licenseServerComp != null && !status.hasServerLicense()) {
            this.licenseServerComp.dispose();
            this.licenseServerComp = null;
        } else if (this.licenseServerComp == null && status.hasServerLicense()) {
            this.licenseServerComp = new LicenseServerSection(this.licenseServerWrapper, 0, this.configView);
        }
        SWTUtil.revalidateLayout((Control)this.licenseServerWrapper);
    }

    private String getServerDescription(Licensing.SDKLicenseInfo license) {
        switch (license.getLicenseSource()) {
            case SERVER: {
                return "License Server";
            }
        }
        return "Unknown";
    }

    public void dispose() {
        Watcher.getInstance().removeLicenseChangeListener(this.licensingListener);
        if (this.licenseServerComp != null) {
            this.licenseServerComp.dispose();
        }
        super.dispose();
    }

    void beforeLicenseCheck() {
        if (this.licenseServerComp != null) {
            this.licenseServerComp.beforeLicenseCheck();
        }
    }
}

