/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.config.ui.AboutSection;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.LicensingSection;
import org.zeroturnaround.eclipse.config.ui.StatisticsSection;
import org.zeroturnaround.jrebel.client.logger.Log;

public final class OverviewPage
extends AbstractPage {
    private static final Log log = Log.getInstance(OverviewPage.class);
    private final BindingContext context = new BindingContext();
    private final Composite mainComposite;
    LicensingSection licensingSection;
    StatisticsSection statisticsSection;

    public OverviewPage(Composite parent, IRebelConfigView configView) {
        super(parent, 0, configView, "Overview");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OverviewPage.this.toolkit.dispose();
            }
        });
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite(this);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        this.mainComposite.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn();
        Composite rightColumn = this.createColumn();
        this.createLicensingSection(leftColumn);
        this.createStatisticsSection(leftColumn);
        this.createAboutSection(rightColumn);
    }

    private Composite createColumn() {
        Composite column = this.toolkit.createComposite(this.mainComposite, 0);
        column.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor(column);
        GridLayout columnLayout = new GridLayout(1, false);
        columnLayout.verticalSpacing = 10;
        column.setLayout((Layout)columnLayout);
        return column;
    }

    private void createLicensingSection(Composite column) {
        Section sctnLicensing = this.createSection(column, "JRebel License", new GridData(4, 0x1000000, true, false, 1, 1));
        this.licensingSection = new LicensingSection((Composite)sctnLicensing, 0, this.configView);
        sctnLicensing.setClient((Control)this.licensingSection);
        this.disposables.add(this.licensingSection);
    }

    private void createAboutSection(Composite column) {
        Section sctnHelpTroubleshooting = this.createSection(column, "About", new GridData(4, 4, true, false, 1, 1));
        AboutSection helpSection = new AboutSection((Composite)sctnHelpTroubleshooting, 0);
        this.toolkit.adapt(helpSection);
        this.toolkit.paintBordersFor(helpSection);
        sctnHelpTroubleshooting.setClient((Control)helpSection);
    }

    private void createStatisticsSection(Composite column) {
        Section sctnStatistics = this.createSection(column, "Time Saved Statistics", new GridData(4, 0x1000000, true, false, 1, 1));
        this.statisticsSection = new StatisticsSection((Composite)sctnStatistics, 0, this.configView);
        this.toolkit.adapt(this.statisticsSection);
        this.toolkit.paintBordersFor(this.statisticsSection);
        sctnStatistics.setClient((Control)this.statisticsSection);
        this.disposables.add(this.statisticsSection);
    }

    private Section createSection(Composite column, String title, Object layoutData) {
        Section section = this.toolkit.createSection(column, 258);
        section.setLayoutData(layoutData);
        this.toolkit.paintBordersFor((Composite)section);
        section.setText(title);
        section.setExpanded(true);
        return section;
    }

    @Override
    public void dispose() {
        this.context.unbindAll();
        super.dispose();
    }

    @Override
    public void onTabSelected() {
        if (this.licensingSection != null) {
            this.licensingSection.beforeLicenseCheck();
        }
    }
}

