/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import java.awt.Desktop;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.common.util.AgentValidationUtil;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.common.options.FilePref;
import org.zeroturnaround.eclipse.common.options.OptionBinding;
import org.zeroturnaround.eclipse.config.components.FileSelectionComponent;
import org.zeroturnaround.eclipse.config.components.PreferenceConfiguration;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.dialog.ConfirmSwitchToNightlyDialog;
import org.zeroturnaround.eclipse.jrebel.ExternalJRebel;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.nightly.NightlyDownloadManager;
import org.zeroturnaround.jrebel.client.nightly.NightlyDownloadState;
import org.zeroturnaround.jrebel.client.nightly.NightlyDto;
import org.zeroturnaround.jrebel.client.nightly.NightlyLookupListener;
import org.zeroturnaround.jrebel.client.nightly.NightlySetupListener;
import org.zeroturnaround.jrebel.client.spi.JRebelClientSettings;

public final class OverviewSection
extends Composite {
    private static final Log log = Log.getInstance(OverviewSection.class);
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private Button btnUseEmbeddedJrebelGriffin;
    private Button btnUseExternalJrebel;
    private Button btnSwitchToNightly;
    private Button btnUpgradeToRelease;
    private Composite wrapperSwitchToNightly;
    private Label labelErrorMessage;
    private BindingContext context = new BindingContext();
    private FileSelectionComponent fileJRebelJar;
    private IRebelConfigView configView;
    private static final String AGENT_LABEL_PREFIX_GRIFFIN = "JRebel Agent";
    private static volatile OverviewSection activeInstance;

    public OverviewSection(Composite parent, int style, IRebelConfigView configView) {
        super(parent, style);
        activeInstance = this;
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite((Composite)this);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.configView = configView;
        this.createJRebelSelectionComponents();
        this.createErrorMessageField();
        this.createNightlySwitchSection();
        this.createOverviewItem();
        this.updateForm();
        this.scheduleAvailableVersionUpdatesCheck();
    }

    private void createNightlySwitchSection() {
        Composite wrapper = new Composite(this.mainComposite, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        wrapper.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        final boolean isCurrentlyNightly = JRebel.getGriffinAgent().getVersion().isSnapshot();
        this.btnUpgradeToRelease = new Button(wrapper, 0);
        this.btnUpgradeToRelease.setText("Upgrade to latest stable build");
        this.btnUpgradeToRelease.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (isCurrentlyNightly) {
                    BrowserUtil.silentOpenLink((String)"https://update.zeroturnaround.com/update-site/");
                } else {
                    EclipseUtil.openUpdateWindow();
                }
            }
        });
        this.btnUpgradeToRelease.setVisible(false);
        GridData btnUpgradeToReleaseGridData = new GridData();
        btnUpgradeToReleaseGridData.exclude = true;
        this.btnUpgradeToRelease.setLayoutData((Object)btnUpgradeToReleaseGridData);
        this.btnUpgradeToRelease.setEnabled(false);
        this.wrapperSwitchToNightly = new Composite(wrapper, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.wrapperSwitchToNightly.setLayout((Layout)layout);
        this.wrapperSwitchToNightly.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnSwitchToNightly = new Button(this.wrapperSwitchToNightly, 0);
        this.btnSwitchToNightly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NightlyDto dto = NightlyDownloadManager.getInstance().getLastResponse();
                if (dto == null) {
                    log.error("Nightly download button was enabled when it shouldn't have been - disabling");
                    OverviewSection.this.setEnableSwitchToNightlyButton((Pair<Boolean, String>)NightlyDownloadManager.BUTTON_STATE_CANNOT_GET_BUILD_INFO);
                    return;
                }
                ConfirmSwitchToNightlyDialog dialog = new ConfirmSwitchToNightlyDialog(OverviewSection.this.getShell(), dto);
                boolean ok = dialog.getResult();
                if (ok) {
                    OverviewSection.this.downloadNightly();
                }
            }
        });
        this.updateSwitchToNightlyButton();
        NightlyDownloadManager.getInstance().refresh(new NightlyLookupListener(){

            public void gotResponse(NightlyDto dto) {
                this.updateButton();
            }

            public void gotError() {
                this.updateButton();
            }

            private void updateButton() {
                if (!OverviewSection.this.isDisposed()) {
                    OverviewSection.this.updateSwitchToNightlyButton();
                }
            }
        });
    }

    private NightlyDownloadManager.StableButtonState getStableUpdateButtonState() {
        PreferenceConfiguration prefs = this.configView.getPrefsConfig();
        if (prefs.useGriffin.getValue().booleanValue()) {
            return NightlyDownloadManager.StableButtonState.NOT_VISIBLE;
        }
        File externalJRebelJar = this.getExternalAgent().getValue();
        File embeddedGriffinJar = JRebel.getGriffinAgent().getJarFile();
        return NightlyDownloadManager.getInstance().getStableUpdateButtonState(externalJRebelJar, embeddedGriffinJar);
    }

    private void updateSwitchToNightlyButton() {
        File externalAgent = this.getExternalAgent().getValue();
        this.setEnableSwitchToNightlyButton((Pair<Boolean, String>)NightlyDownloadManager.getInstance().canStartDownloadOrGetDisabledTooltip(externalAgent));
    }

    private void setEnableSwitchToNightlyButton(final Pair<Boolean, String> enabledAndTooltipPair) {
        EclipseUtil.runInUiThread(new Runnable(){

            @Override
            public void run() {
                if (OverviewSection.this.btnSwitchToNightly.isDisposed()) {
                    return;
                }
                OverviewSection.this.btnSwitchToNightly.setEnabled(((Boolean)enabledAndTooltipPair.getLeft()).booleanValue());
                OverviewSection.this.btnSwitchToNightly.setToolTipText((String)enabledAndTooltipPair.getRight());
                OverviewSection.this.wrapperSwitchToNightly.setToolTipText((String)enabledAndTooltipPair.getRight());
                OverviewSection.this.btnSwitchToNightly.setText(OverviewSection.this.getNightlyButtonText());
            }
        });
    }

    private String getNightlyButtonText() {
        return NightlyDownloadManager.getInstance().getNightlyButtonText(this.getAgentSelection());
    }

    private JRebelClientSettings.AgentSelection getAgentSelection() {
        if (this.btnUseEmbeddedJrebelGriffin.getSelection()) {
            return JRebelClientSettings.AgentSelection.GRIFFIN;
        }
        return JRebelClientSettings.AgentSelection.EXTERNAL;
    }

    private void createOverviewItem() {
        final File folder = JRebelConfiguration.getUserHomeDir().getAbsoluteFile();
        String rebelBase = FilenameUtils.normalize((String)folder.getAbsolutePath());
        this.toolkit.createFormText(this.mainComposite, false).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite ztLabelWrapper = new Composite(this.mainComposite, 0);
        ztLabelWrapper.setLayout((Layout)new GridLayout(1, false));
        ztLabelWrapper.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new ZtLabel(ztLabelWrapper).text("JRebel configuration is stored in:").image(RebelImage.EXPLORE_FOLDER.getImage()).link(rebelBase, new Listener(){

            public void handleEvent(Event event) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(folder);
                    }
                    catch (Exception ex) {
                        log.error("Can't open file folder for browsing [" + folder + ']', (Throwable)ex);
                    }
                }
            }
        });
    }

    private void createJRebelSelectionComponents() {
        Composite composite = new Composite(this.mainComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.btnUseEmbeddedJrebelGriffin = this.createAgentSelectionButton(AGENT_LABEL_PREFIX_GRIFFIN, 3, null, this.configView.getPrefsConfig().useGriffin, composite);
        this.btnUseExternalJrebel = this.createAgentSelectionButton("Other jrebel.jar", 1, "Use a different jrebel.jar version or the nightly build.", null, composite);
        OptionBinding.bindListener(this.context, this.configView.getPrefsConfig().useGriffin, new IValueChangedListener<Boolean>(){

            public void valueChanged(IOption<Boolean> option) {
                if (((Boolean)option.getValue()).booleanValue()) {
                    OverviewSection.this.btnUseExternalJrebel.setSelection(false);
                    OverviewSection.this.fileJRebelJar.setEnabled(false);
                }
            }
        });
        this.fileJRebelJar = new FileSelectionComponent(composite, 0);
        this.fileJRebelJar.setFilterNames(new String[]{"JRebel Agent (jrebel.jar, *.jar)"});
        this.fileJRebelJar.setFilterExtensions(new String[]{"*.jar"});
        this.fileJRebelJar.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.toolkit.adapt((Composite)this.fileJRebelJar);
        this.toolkit.paintBordersFor((Composite)this.fileJRebelJar);
        OptionBinding.bind(this.context, this.fileJRebelJar, this.getExternalAgent());
        OptionBinding.bindListener(this.context, this.getExternalAgent(), option -> this.validateExternalJRebel());
    }

    private FilePref getExternalAgent() {
        return this.configView.getPrefsConfig().jrebelJar;
    }

    private void createErrorMessageField() {
        this.labelErrorMessage = new Label(this.mainComposite, 64);
        this.labelErrorMessage.setLayoutData((Object)new GridData(4, 16384, false, false, 2, 1));
        this.labelErrorMessage.setForeground(this.getDisplay().getSystemColor(3));
        this.labelErrorMessage.setVisible(false);
    }

    private Button createAgentSelectionButton(String buttonLabel, int columns, String toolTip, IOption<Boolean> option, Composite parent) {
        final Button result = new Button(parent, 16);
        result.setText(buttonLabel);
        result.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, columns, 1));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (result.getSelection()) {
                    OverviewSection.this.fileJRebelJar.setEnabled(OverviewSection.this.btnUseExternalJrebel.getSelection());
                    OverviewSection.this.agentSelectionChanged();
                }
            }
        });
        result.setToolTipText(toolTip);
        this.toolkit.adapt((Control)result, true, true);
        if (option != null) {
            OptionBinding.bind(this.context, result, option);
        }
        return result;
    }

    public void updateForm() {
        boolean useEmbeddedGriffin = this.configView.getPrefsConfig().useGriffin.getValue();
        this.btnUseEmbeddedJrebelGriffin.setText(String.format("%s %s", JRebel.getGriffinAgent().getJRebelJar().getHumanReadableVersionInfo(), "(Bundled)"));
        this.btnUseEmbeddedJrebelGriffin.setSelection(useEmbeddedGriffin);
        boolean useExternal = !useEmbeddedGriffin;
        this.btnUseExternalJrebel.setSelection(useExternal);
        this.fileJRebelJar.setEnabled(useExternal);
        if (useExternal) {
            this.validateExternalJRebel();
        }
    }

    public void dispose() {
        this.context.unbindAll();
        if (activeInstance == this) {
            activeInstance = null;
        }
        super.dispose();
    }

    private void validateExternalJRebel() {
        AgentValidationUtil.validateJRebelPath((String)ExternalJRebel.getPathFromPrefs());
    }

    private void agentSelectionChanged() {
        this.labelErrorMessage.setText("You've changed JRebel agent. Please restart the Java VM for the changes to take effect.");
        this.labelErrorMessage.setVisible(true);
        RebelPlugin.getJRebelService().fireStartupConfigurationChangedEvent();
    }

    public JRebelConfiguration getConfiguration() {
        return this.configView.getConfiguration();
    }

    private void downloadNightly() {
        this.setEnableSwitchToNightlyButton((Pair<Boolean, String>)NightlyDownloadManager.BUTTON_STATE_DOWNLOAD_IN_PROGRESS);
        Job job = new Job("Downloading nightly version of JRebel agent"){

            protected IStatus run(final IProgressMonitor monitor) {
                NightlyDownloadManager.getInstance().downloadLatest(new NightlySetupListener(){

                    public void onStateChange(NightlyDownloadState state) {
                        switch (state) {
                            case NEW: {
                                monitor.beginTask(state.getDescription(), 4);
                                break;
                            }
                            case CHECKING_LATEST_VERSION: {
                                monitor.setTaskName(state.getDescription());
                                monitor.worked(1);
                                break;
                            }
                            case DOWNLOADING: {
                                monitor.setTaskName(state.getDescription());
                                monitor.worked(1);
                                break;
                            }
                            case EXTRACTING: {
                                monitor.setTaskName(state.getDescription());
                                monitor.worked(1);
                                break;
                            }
                            case COMPLETE: {
                                monitor.setTaskName(state.getDescription());
                                this.finishJob(Status.OK_STATUS);
                                break;
                            }
                            case CANCELLED: 
                            case ERROR: {
                                monitor.setTaskName(state.getDescription());
                                this.finishJob(Status.CANCEL_STATUS);
                                break;
                            }
                            default: {
                                log.warn("Unexpected state " + state + ", finishing progressmonitor", new Throwable());
                                this.finishJob(Status.CANCEL_STATUS);
                            }
                        }
                    }

                    public void onAgentReady(final File agent) {
                        EclipseUtil.runInUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((OverviewSection)((this).this).OverviewSection.this).configView.getPrefsConfig().useGriffin.setValue(false);
                                OverviewSection.this.getExternalAgent().setValue(agent);
                                OverviewSection instance = OverviewSection.this.getNonDisposedInstance();
                                if (instance == null) {
                                    RebelPlugin.getJRebelService().fireStartupConfigurationChangedEvent();
                                } else {
                                    instance.updateForm();
                                    instance.agentSelectionChanged();
                                }
                            }
                        });
                    }

                    public boolean isCancelled() {
                        return monitor.isCanceled();
                    }
                });
                return Job.ASYNC_FINISH;
            }

            private void finishJob(IStatus status) {
                this.done(status);
                OverviewSection instance = OverviewSection.this.getNonDisposedInstance();
                if (instance != null) {
                    if (status == Status.OK_STATUS) {
                        instance.setEnableSwitchToNightlyButton((Pair<Boolean, String>)NightlyDownloadManager.BUTTON_STATE_ALREADY_LATEST);
                    } else {
                        instance.updateSwitchToNightlyButton();
                    }
                }
                NightlyDownloadManager.getInstance().refresh(NightlyLookupListener.NOP_LISTENER);
            }
        };
        job.schedule();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OverviewSection getNonDisposedInstance() {
        if (!this.isDisposed()) return this;
        if (activeInstance == null) return null;
        if (!activeInstance.isDisposed()) return activeInstance;
        activeInstance = null;
        return null;
    }

    private void scheduleAvailableVersionUpdatesCheck() {
        Job job = new Job("Checking latest JRebel version"){

            protected IStatus run(IProgressMonitor monitor) {
                NightlyDownloadManager.StableButtonState stableUpdateButtonState = OverviewSection.this.getStableUpdateButtonState();
                log.trace("Obtained update button state to set: {}", (Object)stableUpdateButtonState);
                OverviewSection.this.getDisplay().asyncExec(() -> {
                    if (!OverviewSection.this.isDisposed()) {
                        log.trace("Updating UI with update button state {}", (Object)stableUpdateButtonState);
                        boolean releaseUpdateButtonVisible = stableUpdateButtonState.isVisible();
                        boolean newStableVersionAvailable = stableUpdateButtonState.isEnabled();
                        if (releaseUpdateButtonVisible && newStableVersionAvailable) {
                            OverviewSection.this.labelErrorMessage.setText("You are running the JRebel Agent nightly build! Consider switching to latest stable version.");
                            OverviewSection.this.labelErrorMessage.setVisible(true);
                        }
                        ((GridData)((OverviewSection)OverviewSection.this).btnUpgradeToRelease.getLayoutData()).exclude = !releaseUpdateButtonVisible;
                        OverviewSection.this.btnUpgradeToRelease.setVisible(releaseUpdateButtonVisible);
                        OverviewSection.this.btnUpgradeToRelease.setEnabled(newStableVersionAvailable);
                        OverviewSection.this.layout(true, true);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

