/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.widgets.RemoteServerGrid;
import org.zeroturnaround.eclipse.preferences.PreferenceReader;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.remoteservers.RemoteServerDialog;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public final class RemoteServersPage
extends AbstractPage {
    public static final int DRAW_AREA_WIDTH = 650;
    private final Composite mainComposite;
    private final Composite leftColumn;
    private Composite tableDrawArea;
    private ScrolledComposite scrolledPanel;
    private Label noServers;
    private static final Log log = Log.getInstance(RemoteServersPage.class);

    public RemoteServersPage(Composite parent, IRebelConfigView configView) {
        super(parent, 0, configView, "Remote servers");
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite(this);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.leftColumn = this.toolkit.createComposite(this.mainComposite, 0);
        GridData gridData = new GridData(4, 4, false, true, 1, 1);
        gridData.minimumWidth = 650;
        gridData.widthHint = 650;
        this.leftColumn.setLayoutData((Object)gridData);
        this.toolkit.paintBordersFor(this.leftColumn);
        GridLayout leftColumnLayout = new GridLayout(1, false);
        leftColumnLayout.verticalSpacing = 3;
        leftColumnLayout.horizontalSpacing = 0;
        leftColumnLayout.marginWidth = 0;
        this.leftColumn.setLayout((Layout)leftColumnLayout);
        final RemoteServerConfigurations.ChangeListener rscListener = () -> EclipseUtil.runInUiThread(this::updateTable);
        final RemoteServerConfigurations remoteServers = IdeRemoting.getInstance().getConfigurations();
        remoteServers.addListener(rscListener);
        remoteServers.reloadGlobalStorageAsync();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                log.trace("widgetDisposed()");
                remoteServers.removeListener(rscListener);
                RemoteServersPage.this.toolkit.dispose();
            }
        });
        this.createHeader(this.leftColumn);
        this.createNoServerLabel(this.leftColumn);
        Composite rightColumn = this.toolkit.createComposite(this.mainComposite, 0);
        GridLayout rightColumnLayout = new GridLayout(1, false);
        rightColumnLayout.marginHeight = 20;
        rightColumnLayout.marginWidth = 20;
        rightColumn.setLayout((Layout)rightColumnLayout);
        GridData rightColumnLayoutData = new GridData(4, 4, true, false, 1, 1);
        rightColumn.setLayoutData((Object)rightColumnLayoutData);
        this.createDescriptionPanel(rightColumn);
        this.updateTable();
        this.leftColumn.setBackgroundMode(2);
    }

    private void initScrolledPanel() {
        if (this.scrolledPanel != null) {
            return;
        }
        Composite scrolledPanelHolder = new Composite(this.leftColumn, 0);
        GridLayout scrolledLayout = new GridLayout();
        scrolledLayout.marginHeight = 0;
        scrolledLayout.marginWidth = 0;
        scrolledPanelHolder.setLayout((Layout)scrolledLayout);
        GridData layoutDataSPH = new GridData(4, 4, true, false);
        layoutDataSPH.heightHint = 600;
        scrolledPanelHolder.setLayoutData((Object)layoutDataSPH);
        this.scrolledPanel = new ScrolledComposite(scrolledPanelHolder, 512);
        this.scrolledPanel.setLayoutData((Object)layoutDataSPH);
        this.scrolledPanel.setExpandHorizontal(true);
        this.scrolledPanel.setExpandVertical(true);
        this.scrolledPanel.setBackgroundMode(2);
    }

    private void updateTable() {
        this.initScrolledPanel();
        this.reCreateTableDrawArea();
        int serverCount = IdeRemoting.getInstance().getConfigurations().getInstanceServers().size();
        if (serverCount > 0) {
            this.showNoServersLabel(false);
            this.createTable(this.tableDrawArea);
            this.createFooter(this.tableDrawArea);
            new Label(this.tableDrawArea, 0);
            RemoteServersPage.buildReviewYourProjectSettingsLink(this.tableDrawArea);
        } else {
            this.showNoServersLabel(true);
            new Label(this.tableDrawArea, 0);
            this.createFooter(this.tableDrawArea);
        }
        this.layout(false, true);
        ScrollBars.contentsChanged(this.tableDrawArea);
    }

    private void createHeader(Composite parent) {
        Composite container = this.toolkit.createComposite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 2;
        container.setLayout((Layout)layout);
        new BoldLabel(container, "Select servers for JRebel synchronization");
        Button button = new Button(container, 0);
        button.setText("Add server");
        this.toolkit.adapt((Control)button, true, true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                log.trace("add server pressed");
                RemoteServersPage.this.openRemoteServerDialog();
            }
        });
    }

    void openRemoteServerDialog() {
        new RemoteServerDialog(this.getShell()).open();
    }

    private void createTable(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 18;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        new RemoteServerGrid(composite, IdeRemoting.getInstance().getConfigurations());
    }

    private void createNoServerLabel(Composite parent) {
        this.noServers = new Label(parent, 0);
        this.noServers.setLayoutData((Object)new GridData());
        this.noServers.setText("No servers configured. Press Add server to get started.");
    }

    private void showNoServersLabel(boolean visible) {
        if (this.noServers != null && !this.noServers.isDisposed()) {
            ((GridData)this.noServers.getLayoutData()).exclude = !visible;
            this.noServers.setVisible(visible);
        }
    }

    private void createFooter(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Synchronize on build");
        button.setSelection(PreferenceReader.isSyncOnBuildGlobal());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                log.trace("SoB checkbox new value: " + button.getSelection());
                PreferenceReader.setSyncOnBuildGlobal(button.getSelection());
            }
        });
    }

    private void reCreateTableDrawArea() {
        if (this.tableDrawArea != null) {
            this.tableDrawArea.dispose();
        }
        this.tableDrawArea = null;
        this.tableDrawArea = this.toolkit.createComposite((Composite)this.scrolledPanel);
        this.tableDrawArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor(this.tableDrawArea);
        GridLayout tableDrawAreaLayout = new GridLayout(1, false);
        tableDrawAreaLayout.verticalSpacing = 10;
        tableDrawAreaLayout.marginTop = 0;
        tableDrawAreaLayout.marginHeight = 0;
        tableDrawAreaLayout.marginWidth = 0;
        this.tableDrawArea.setLayout((Layout)tableDrawAreaLayout);
        this.tableDrawArea.setBackgroundMode(2);
        this.scrolledPanel.setContent((Control)this.tableDrawArea);
    }

    private void createDescriptionPanel(Composite outerParent) {
        Composite parent = new Composite(outerParent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        GridData gridData = new GridData(131072, 128, true, true, 1, 1);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gridData);
        parent.setBackground(Display.getCurrent().getSystemColor(22));
        ZtLabel label = new ZtLabel(parent).text("These servers will be used for projects configured the with ").newline();
        if (EnvironmentUtil.isMac()) {
            label.text("option 'Use all active remote servers'. Alternatively, you");
        } else {
            label.text("option").bold("Use all active remote servers.").text("Alternatively, you");
        }
        label.newline().text("can select specific remote servers for each project from").newline().text("project settings.");
    }

    public static void buildReviewYourProjectSettingsLink(Composite container) {
        Listener listener = event -> JRebelConfigCenter.openProjects();
        new ZtLabel(container).text("Next \u2192 ").link("enable remote server support for your projects", listener).image(RebelImage.JREBEL_CLOUD.getImage());
    }
}

