/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.config.extension.ConfigCenterServersTabProviders;
import org.zeroturnaround.eclipse.config.extension.IConfigCenterServersTabProvider;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.servers.NoJeeServersTabProvider;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.SWTStartupCLIPanel;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.SWTStartupRemotePanel;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.jrebel.ide.common.startup.StartupScenario;
import org.zeroturnaround.jrebel.ide.common.startup.StartupScenarioPreferences;

public final class StartupPage
extends AbstractPage {
    public static final int DRAW_AREA_WIDTH = 700;
    private final Composite mainComposite;
    private StartupModel[] startupScenarios = new StartupModel[3];
    private Composite startupScenarioDrawArea;
    private ScrolledComposite scrolledPanel;
    private final Composite leftColumn;
    private IConfigCenterServersTabProvider runViaIdeTabProvider;

    public StartupPage(Composite parent, IRebelConfigView configView) {
        super(parent, 0, configView, "Startup");
        this.addDisposeListener(event -> {
            this.rememberSelectedRadioButton();
            this.toolkit.dispose();
        });
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite(this);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 10;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.leftColumn = this.toolkit.createComposite(this.mainComposite, 0);
        GridData gridData = new GridData(4, 4, false, true, 1, 1);
        gridData.minimumWidth = 700;
        gridData.widthHint = 700;
        this.leftColumn.setLayoutData((Object)gridData);
        this.toolkit.paintBordersFor(this.leftColumn);
        GridLayout leftColumnLayout = new GridLayout(1, false);
        leftColumnLayout.verticalSpacing = 3;
        leftColumnLayout.horizontalSpacing = 0;
        leftColumnLayout.marginWidth = 0;
        this.leftColumn.setLayout((Layout)leftColumnLayout);
        new BoldLabel(this.leftColumn, "How do you run your server or application?");
        this.createRadioButtons(this.leftColumn);
        this.createHorizontalSplitter(this.leftColumn);
        this.initializeContentProviders();
        this.updateStartupScenario();
    }

    private void initializeContentProviders() {
        IConfigCenterServersTabProvider[] providers;
        IConfigCenterServersTabProvider[] iConfigCenterServersTabProviderArray = providers = ConfigCenterServersTabProviders.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigCenterServersTabProvider provider = iConfigCenterServersTabProviderArray[n2];
            String name = provider.getClass().getName();
            if (name.equals("org.zeroturnaround.eclipse.wtp.ui.config.WTPServersTabProvider")) {
                this.runViaIdeTabProvider = provider;
            }
            ++n2;
        }
        if (this.runViaIdeTabProvider == null) {
            this.runViaIdeTabProvider = new NoJeeServersTabProvider();
        }
    }

    private void createRadioButtons(Composite parent) {
        int rememberedSelection = this.getRememberedRadioButton();
        Composite radiosComposite = this.toolkit.createComposite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 20;
        layout.marginHeight = 10;
        radiosComposite.setLayout((Layout)layout);
        this.createRadio(radiosComposite, 0, "Run via IDE", rememberedSelection, StartupScenario.IDE, "Review and configure application servers launched via your IDE. JRebel startup parameter will be added to any server you enable from here.");
        this.createRadio(radiosComposite, 1, "Run locally from command line", rememberedSelection, StartupScenario.CLI, "Generate and review startup scripts for servers launched from outside the IDE on local machine. JRebel startup parameter has to be present in the server startup script.");
        this.createRadio(radiosComposite, 2, "Run on a remote server or VM", rememberedSelection, StartupScenario.REMOTE, "Generate and review startup scripts for servers launched on a remote machine. JRebel startup parameter has to be present in the remote server startup script.");
    }

    private void createRadio(Composite parent, int index, String text, int rememberedSelection, StartupScenario scenario, String toolTipText) {
        final Button radio = new Button(parent, 16);
        radio.setSelection(index == rememberedSelection);
        radio.setText(text);
        radio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (radio.getSelection()) {
                    StartupPage.this.saveSelectedTabToPrefs();
                    StartupPage.this.updateStartupScenario();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StartupPage.this.updateStartupScenario();
            }
        });
        radio.setToolTipText(toolTipText);
        this.startupScenarios[index] = new StartupModel(scenario, radio);
    }

    private void createHorizontalSplitter(Composite leftColumn) {
        Label separator = new Label(leftColumn, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void createRunViaIDEPage(Composite parent) {
        new BoldLabel(parent, "JRebel is automatically enabled for new servers and standalone applications.");
        Composite area4 = this.toolkit.createComposite(parent);
        area4.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout layout4 = new GridLayout(4, true);
        layout4.horizontalSpacing = 0;
        layout4.marginWidth = 0;
        layout4.marginHeight = 0;
        area4.setLayout((Layout)layout4);
        Composite area3 = this.toolkit.createComposite(area4);
        area3.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        GridLayout layout3 = new GridLayout(1, true);
        layout3.horizontalSpacing = 0;
        layout3.marginWidth = 0;
        layout3.marginHeight = 0;
        area3.setLayout((Layout)layout3);
        this.runViaIdeTabProvider.createControl(area3);
        new BoldLabel(parent, "To disable JRebel for standalone applications, open project run configuration.");
        parent.setSize(parent.computeSize(-1, -1, true));
    }

    private void createRunUsingCLIPage(Composite parent) {
        new SWTStartupCLIPanel(parent, 0);
    }

    private void createRunOnARemoteServerPage(Composite parent) {
        new SWTStartupRemotePanel(parent, 0);
    }

    private void updateStartupScenario() {
        this.reCreateStartupScenarioDrawArea();
        if (this.startupScenarios[0].radio.getSelection()) {
            this.createRunViaIDEPage(this.startupScenarioDrawArea);
        } else if (this.startupScenarios[1].radio.getSelection()) {
            this.createRunUsingCLIPage(this.startupScenarioDrawArea);
        } else if (this.startupScenarios[2].radio.getSelection()) {
            this.createRunOnARemoteServerPage(this.startupScenarioDrawArea);
        }
        this.layout(false, true);
        ScrollBars.contentsChanged(this.startupScenarioDrawArea);
    }

    private void reCreateStartupScenarioDrawArea() {
        if (this.scrolledPanel != null) {
            this.scrolledPanel.dispose();
        }
        this.scrolledPanel = null;
        this.startupScenarioDrawArea = null;
        this.scrolledPanel = new ScrolledComposite(this.leftColumn, 512);
        this.scrolledPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledPanel.setExpandHorizontal(true);
        this.scrolledPanel.setExpandVertical(true);
        this.scrolledPanel.setBackgroundMode(2);
        this.startupScenarioDrawArea = this.toolkit.createComposite((Composite)this.scrolledPanel);
        this.startupScenarioDrawArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor(this.startupScenarioDrawArea);
        GridLayout startupScenarioLayout = new GridLayout(1, false);
        startupScenarioLayout.verticalSpacing = 0;
        startupScenarioLayout.marginTop = 15;
        startupScenarioLayout.marginHeight = 0;
        startupScenarioLayout.marginWidth = 0;
        this.startupScenarioDrawArea.setLayout((Layout)startupScenarioLayout);
        this.scrolledPanel.setContent((Control)this.startupScenarioDrawArea);
        this.leftColumn.setSize(this.leftColumn.computeSize(-1, -1, true));
        this.leftColumn.setRedraw(true);
    }

    public void selectScenario(StartupScenario selectScenario) {
        if (selectScenario != null) {
            boolean isUpdateNeeded = false;
            StartupModel[] startupModelArray = this.startupScenarios;
            int n = this.startupScenarios.length;
            int n2 = 0;
            while (n2 < n) {
                StartupModel startupScenario = startupModelArray[n2];
                boolean shouldBeSelected = startupScenario.scenario.equals((Object)selectScenario);
                boolean currentValue = startupScenario.radio.getSelection();
                startupScenario.radio.setSelection(shouldBeSelected);
                isUpdateNeeded |= currentValue ^ shouldBeSelected;
                ++n2;
            }
            if (isUpdateNeeded) {
                this.saveSelectedTabToPrefs();
                this.updateStartupScenario();
            }
        }
    }

    private void rememberSelectedRadioButton() {
        int i = 0;
        while (i < this.startupScenarios.length) {
            if (this.startupScenarios[i].radio.getSelection()) {
                RebelPlugin.getDefault().getPreferenceStore().setValue("jrebelRunViaIdeRadio", i);
                break;
            }
            ++i;
        }
    }

    private int getRememberedRadioButton() {
        return RebelPlugin.getDefault().getPreferenceStore().getInt("jrebelRunViaIdeRadio");
    }

    @Override
    public void onTabSelected() {
        this.saveSelectedTabToPrefs();
    }

    private void saveSelectedTabToPrefs() {
        StartupModel[] startupModelArray = this.startupScenarios;
        int n = this.startupScenarios.length;
        int n2 = 0;
        while (n2 < n) {
            StartupModel startupScenario = startupModelArray[n2];
            if (startupScenario.radio.getSelection()) {
                StartupScenarioPreferences.saveIdeStartupScenario((StartupScenario)startupScenario.scenario);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void updateContent() {
        this.updateStartupScenario();
    }

    private static class StartupModel {
        final StartupScenario scenario;
        final Button radio;

        StartupModel(StartupScenario scenario, Button radio) {
            this.scenario = scenario;
            this.radio = radio;
        }
    }
}

