/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.TurnaroundTimeSliderOption;
import org.zeroturnaround.eclipse.common.options.BindingContext;
import org.zeroturnaround.eclipse.common.options.OptionBinding;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.stats.TimeSavedStats;

public final class StatisticsSection
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private BindingContext context = new BindingContext();
    private Text text;

    public StatisticsSection(Composite parent, int style, IRebelConfigView configView) {
        super(parent, style);
        JRebelConfiguration configuration = configView.getConfiguration();
        TurnaroundTimeSliderOption turnaroundTimeOpt = new TurnaroundTimeSliderOption((IOption)configuration.avgRedeployTime());
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite((Composite)this);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(this.mainComposite, "Time it takes you to redeploy", 0);
        Composite composite = this.toolkit.createComposite(this.mainComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(9, true);
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTimeLabels(composite);
        Scale scale = new Scale(composite, 0);
        scale.setPageIncrement(30);
        scale.setMaximum(240);
        scale.setLayoutData((Object)new GridData(4, 128, true, false, 9, 1));
        OptionBinding.bind(this.context, scale, (IOption<Integer>)turnaroundTimeOpt);
        Label valueLabel = this.toolkit.createLabel(composite, "5s", 0);
        GridData valueLabelGridData = new GridData(4, 0x1000000, false, false, 9, 1);
        valueLabelGridData.horizontalIndent = 10;
        valueLabel.setLayoutData((Object)valueLabelGridData);
        OptionBinding.bindView(this.context, valueLabel, configuration.avgRedeployTime(), TurnaroundTimeSliderOption::asText);
        this.text = new Text(this.mainComposite, 64);
        this.text.setEnabled(false);
        this.text.setForeground(this.text.getForeground());
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.text.setText("Please wait, querying for statistics...");
        this.updateStatistics();
    }

    private void createTimeLabels(Composite composite) {
        String[] times;
        String[] stringArray = times = new String[]{"1s", "30s", "1min", "2min", "3min", "5min", "15min", "30min", "1h"};
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            String time = stringArray[n2];
            this.toolkit.createLabel(composite, time, 0).setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            ++n2;
        }
    }

    private void updateStatistics() {
        new Job("Querying JRebel statistics"){

            protected IStatus run(IProgressMonitor monitor) {
                EclipseUtil.runInUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!StatisticsSection.this.text.isDisposed()) {
                            StatisticsSection.this.text.setText(String.valueOf(TimeSavedStats.getText()) + "\n \n ");
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void dispose() {
        this.context.unbindAll();
        super.dispose();
    }
}

