/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextLabel;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;

public class ConfirmSwitchToExternalGenerationDialog
extends MessageDialog {
    private static final String[] buttons = new String[]{"Proceed", IDialogConstants.CANCEL_LABEL};
    private final List<EclipseIdeProject> modules;

    private ConfirmSwitchToExternalGenerationDialog(Shell shell, List<EclipseIdeProject> modules) {
        super(shell, "Confirm switching projects to external rebel.xml generation", RebelImage.JREBEL.getImage(), null, 4, buttons, 0);
        this.modules = modules;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        int count = this.modules.size();
        String projectText = "project" + (count == 1 ? "" : "s");
        String thisThese = count == 1 ? "this" : "these";
        new ZtLabel(composite).text("Are you sure you want to switch ").macSafeBold(String.format("%s %d %s", thisThese, count, projectText)).text(" to external rebel.xml").newline().newline().text("generation? This might take some time.");
        this.createModulesList(composite);
        return composite;
    }

    private void createModulesList(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        parent.setLayout((Layout)new GridLayout(1, false));
        new IdeGenerationProjectsGrid(composite, this.modules);
    }

    public static boolean openQuestion(Shell shell, List<EclipseIdeProject> modules) {
        ConfirmSwitchToExternalGenerationDialog dialog = new ConfirmSwitchToExternalGenerationDialog(shell, modules);
        int button = dialog.open();
        return button == 0;
    }

    private static class IdeGenerationProjectsGrid {
        private IdeGenerationProjectsGrid(Composite parent, List<EclipseIdeProject> modules) {
            Composite container = this.createThinChild(parent);
            ScrollBars scrollBars = new ScrollBars(container, 512);
            Composite scrolledSpace = scrollBars.content;
            for (EclipseIdeProject module : modules) {
                new SpacedTextLabel(scrolledSpace, 1).setText(module.getName());
            }
            GridData data = new GridData(0);
            data.heightHint = Math.min(parent.computeSize((int)-1, (int)-1).y - 100, 200);
            container.setLayoutData((Object)data);
            scrollBars.contentsChanged();
        }

        private Composite createThinChild(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            container.setLayout((Layout)layout);
            return container;
        }
    }
}

