/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.launchables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.config.components.ICheckStateAdapter;
import org.zeroturnaround.eclipse.config.ui.launchables.ILaunchablesProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.RebelLaunchablesTable;
import org.zeroturnaround.eclipse.launching.IRebelLaunchable;
import org.zeroturnaround.jrebel.client.logger.Log;

public class LaunchablesCheckStateAdapter<L, C>
implements ICheckStateAdapter {
    private static final Log log = Log.getInstance(RebelLaunchablesTable.class);
    private final ILaunchablesProvider<L, C> provider;
    private final RebelLaunchablesTable<L, C> table;

    public LaunchablesCheckStateAdapter(ILaunchablesProvider<L, C> provider, RebelLaunchablesTable<L, C> table) {
        this.provider = provider;
        this.table = table;
    }

    @Override
    public boolean isChecked(Object element) {
        if (this.provider.isLaunchableType(element)) {
            try {
                Object launchable = element;
                IRebelLaunchable<Object, C> adapter = this.provider.getAdapter(launchable);
                return adapter != null && adapter.isJRebelEnabled(launchable);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.table.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean checked = event.getChecked();
                IRebelLaunchable adapter = null;
                if (LaunchablesCheckStateAdapter.this.provider.isLaunchableType(event.getElement())) {
                    adapter = LaunchablesCheckStateAdapter.this.provider.getAdapter(event.getElement());
                }
                if (adapter != null) {
                    try {
                        LaunchablesCheckStateAdapter.this.provider.bind(adapter, event.getElement()).setJRebelEnabled(checked);
                        LaunchablesCheckStateAdapter.this.refreshElement(event);
                        RebelPlugin.getJRebelService().fireRebelEnablementChangedEvent((Object)LaunchablesCheckStateAdapter.this.table, event.getElement(), checked);
                    }
                    catch (CoreException e) {
                        log.error((Throwable)e);
                    }
                } else {
                    ICheckable checkable = event.getCheckable();
                    checkable.setChecked(event.getElement(), false);
                }
            }
        });
    }

    protected void refreshElement(CheckStateChangedEvent event) {
        this.table.treeViewer.refresh(event.getElement());
    }
}

